/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.ch.qos.logback.core.util;

public class EnvUtil {
    private static boolean isJDK_N_OrHigher(int n) {
        String javaVersionStr = System.getProperty("java.version", "");
        if (javaVersionStr.isEmpty()) {
            return false;
        }
        int version = EnvUtil.getJDKVersion(javaVersionStr);
        return version > 0 && n <= version;
    }

    public static int getJDKVersion(String javaVersionStr) {
        int version = 0;
        for (char ch : javaVersionStr.toCharArray()) {
            if (Character.isDigit(ch)) {
                version = version * 10 + (ch - 48);
                continue;
            }
            if (version != 1) break;
            version = 0;
        }
        return version;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK9OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(9);
    }

    public static boolean isJaninoAvailable() {
        ClassLoader classLoader = EnvUtil.class.getClassLoader();
        try {
            Class<?> bindingClass = classLoader.loadClass("org.codehaus.janino.ScriptEvaluator");
            return bindingClass != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }
}

