/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.Label;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.MethodWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.Symbol;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.SymbolTable;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.Type;

class Frame {
    static final int SAME_FRAME = 0;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
    static final int CHOP_FRAME = 248;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int APPEND_FRAME = 252;
    static final int FULL_FRAME = 255;
    static final int ITEM_TOP = 0;
    static final int ITEM_INTEGER = 1;
    static final int ITEM_FLOAT = 2;
    static final int ITEM_DOUBLE = 3;
    static final int ITEM_LONG = 4;
    static final int ITEM_NULL = 5;
    static final int ITEM_UNINITIALIZED_THIS = 6;
    static final int ITEM_OBJECT = 7;
    static final int ITEM_UNINITIALIZED = 8;
    static final int ITEM_ASM_BOOLEAN = 9;
    static final int ITEM_ASM_BYTE = 10;
    static final int ITEM_ASM_CHAR = 11;
    static final int ITEM_ASM_SHORT = 12;
    static final int DIM_SIZE = 6;
    static final int KIND_SIZE = 4;
    static final int FLAGS_SIZE = 2;
    static final int VALUE_SIZE = 20;
    static final int DIM_SHIFT = 26;
    static final int KIND_SHIFT = 22;
    static final int FLAGS_SHIFT = 20;
    static final int DIM_MASK = -67108864;
    static final int KIND_MASK = 0x3C00000;
    static final int VALUE_MASK = 1048575;
    static final int ELEMENT_OF = -67108864;
    static final int CONSTANT_KIND = 0x400000;
    static final int REFERENCE_KIND = 0x800000;
    static final int UNINITIALIZED_KIND = 0xC00000;
    static final int LOCAL_KIND = 0x1000000;
    static final int STACK_KIND = 0x1400000;
    private static final int TOP_IF_LONG_OR_DOUBLE_FLAG = 0x100000;
    private static final int TOP = 0x400000;
    private static final int BOOLEAN = 0x400009;
    private static final int BYTE = 0x40000A;
    private static final int CHAR = 0x40000B;
    private static final int SHORT = 0x40000C;
    private static final int INTEGER = 0x400001;
    private static final int FLOAT = 0x400002;
    private static final int LONG = 0x400004;
    private static final int DOUBLE = 0x400003;
    private static final int NULL = 0x400005;
    private static final int UNINITIALIZED_THIS = 0x400006;
    final Label owner;
    private int[] inputLocals;
    int[] inputStack;
    private int[] outputLocals;
    private int[] outputStack;
    private short outputStackStart;
    private short outputStackTop;
    private int initializationCount;
    private int[] initializations;

    Frame(Label owner) {
        this.owner = owner;
    }

    private static int getAbstractTypeFromDescriptor(SymbolTable symbolTable, String buffer, int offset) {
        String internalName = null;
        switch (buffer.charAt(offset)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0x400001;
            }
            case 'F': {
                return 0x400002;
            }
            case 'J': {
                return 0x400004;
            }
            case 'D': {
                return 0x400003;
            }
            case 'L': {
                if (offset == 0) {
                    switch (buffer) {
                        case "Ljava/lang/Object;": {
                            internalName = "java/lang/Object";
                            break;
                        }
                        case "Ljava/lang/Class;": {
                            internalName = "java/lang/Class";
                            break;
                        }
                        case "Ljava/lang/String;": {
                            internalName = "java/lang/String";
                            break;
                        }
                        case "Ljava/util/List;": {
                            internalName = "java/util/List";
                            break;
                        }
                        case "Ljava/lang/reflect/Type;": {
                            internalName = "java/lang/reflect/Type";
                            break;
                        }
                        case "Ljava/util/function/Supplier;": {
                            internalName = "java/util/function/Supplier";
                            break;
                        }
                        case "Lsun/misc/Unsafe;": {
                            internalName = "sun/misc/Unsafe";
                            break;
                        }
                        case "Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/JSONReader;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/JSONReader";
                            break;
                        }
                        case "Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/reader/FieldReader;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/reader/FieldReader";
                            break;
                        }
                        case "Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/reader/ObjectReader;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/reader/ObjectReader";
                            break;
                        }
                        case "Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/JSONWriter;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/JSONWriter";
                            break;
                        }
                        case "Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/writer/FieldWriter;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/writer/FieldWriter";
                            break;
                        }
                    }
                } else if (offset == 2) {
                    switch (buffer) {
                        case "()Ljava/lang/Class;": {
                            internalName = "java/lang/Class";
                            break;
                        }
                        case "()Ljava/lang/String;": {
                            internalName = "java/lang/String";
                            break;
                        }
                    }
                } else if (offset == 3) {
                    switch (buffer) {
                        case "(J)Lcom/alibaba/fastjson2/reader/FieldReader;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/reader/FieldReader";
                            break;
                        }
                        case "(I)Ljava/lang/Object;": {
                            internalName = "java/lang/Object";
                            break;
                        }
                        case "(I)Ljava/lang/Integer;": {
                            internalName = "java/lang/Integer";
                            break;
                        }
                    }
                } else if (offset == 36) {
                    switch (buffer) {
                        case "(Lcom/alibaba/fastjson2/JSONReader;)Lcom/alibaba/fastjson2/reader/ObjectReader;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/reader/ObjectReader";
                            break;
                        }
                        case "(Lcom/alibaba/fastjson2/JSONReader;)Ljava/lang/Object;": {
                            internalName = "java/lang/Object";
                            break;
                        }
                    }
                } else if (offset == 54) {
                    switch (buffer) {
                        case "(Lcom/alibaba/fastjson2/JSONReader;Ljava/lang/Class;J)Lcom/alibaba/fastjson2/reader/ObjectReader;": {
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/reader/ObjectReader";
                            break;
                        }
                        case "(Lcom/alibaba/fastjson2/JSONReader;Ljava/lang/Class;J)Ljava/lang/Object;": {
                            internalName = "java/lang/Object";
                            break;
                        }
                    }
                } else {
                    switch (buffer) {
                        case "(Lcom/alibaba/fastjson2/JSONWriter;Ljava/lang/Class;)Lcom/alibaba/fastjson2/writer/ObjectWriter;": {
                            if (offset != 53) break;
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/writer/ObjectWriter";
                            break;
                        }
                        case "(Lcom/alibaba/fastjson2/JSONWriter;Ljava/lang/reflect/Type;)Lcom/alibaba/fastjson2/writer/ObjectWriter;": {
                            if (offset != 60) break;
                            internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/writer/ObjectWriter";
                            break;
                        }
                        case "(Lcom/alibaba/fastjson2/writer/FieldWriter;Ljava/lang/Object;)Ljava/lang/String;": {
                            if (offset != 62) break;
                            internalName = "java/lang/String";
                            break;
                        }
                        case "(Lcom/alibaba/fastjson2/JSONReader;Ljava/lang/reflect/Type;Ljava/lang/Object;J)Ljava/lang/Object;": {
                            if (offset != 79) break;
                            internalName = "java/lang/Object";
                            break;
                        }
                    }
                }
                if (internalName == null) {
                    internalName = buffer.substring(offset + 1, buffer.length() - 1);
                }
                return 0x800000 | symbolTable.addType(internalName);
            }
            case '[': {
                int typeValue;
                int elementDescriptorOffset = offset + 1;
                while (buffer.charAt(elementDescriptorOffset) == '[') {
                    ++elementDescriptorOffset;
                }
                switch (buffer.charAt(elementDescriptorOffset)) {
                    case 'Z': {
                        typeValue = 0x400009;
                        break;
                    }
                    case 'C': {
                        typeValue = 0x40000B;
                        break;
                    }
                    case 'B': {
                        typeValue = 0x40000A;
                        break;
                    }
                    case 'S': {
                        typeValue = 0x40000C;
                        break;
                    }
                    case 'I': {
                        typeValue = 0x400001;
                        break;
                    }
                    case 'F': {
                        typeValue = 0x400002;
                        break;
                    }
                    case 'J': {
                        typeValue = 0x400004;
                        break;
                    }
                    case 'D': {
                        typeValue = 0x400003;
                        break;
                    }
                    case 'L': {
                        if (offset == 0) {
                            switch (buffer) {
                                case "[Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/writer/FieldWriter;": {
                                    internalName = "com/alibaba/arthas/deps/com/alibaba/fastjson2/reader/FieldReader";
                                    break;
                                }
                                case "[Lcom/alibaba/arthas/deps/com/alibaba/fastjson2/reader/FieldReader;": {
                                    internalName = "Lcom/alibaba/fastjson2/reader/FieldReader";
                                    break;
                                }
                            }
                        }
                        if (internalName == null) {
                            internalName = buffer.substring(elementDescriptorOffset + 1, buffer.length() - 1);
                        }
                        typeValue = 0x800000 | symbolTable.addType(internalName);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return elementDescriptorOffset - offset << 26 | typeValue;
            }
        }
        throw new IllegalArgumentException();
    }

    final void setInputFrameFromDescriptor(SymbolTable symbolTable, int access, String descriptor, int maxLocals) {
        this.inputLocals = new int[maxLocals];
        this.inputStack = new int[0];
        int inputLocalIndex = 0;
        if ((access & 8) == 0) {
            this.inputLocals[inputLocalIndex++] = (access & 0x40000) == 0 ? 0x800000 | symbolTable.addType(symbolTable.className) : 0x400006;
        }
        for (Type argumentType : Type.getArgumentTypes(descriptor)) {
            int abstractType = Frame.getAbstractTypeFromDescriptor(symbolTable, argumentType.getDescriptor(), 0);
            this.inputLocals[inputLocalIndex++] = abstractType;
            if (abstractType != 0x400004 && abstractType != 0x400003) continue;
            this.inputLocals[inputLocalIndex++] = 0x400000;
        }
        while (inputLocalIndex < maxLocals) {
            this.inputLocals[inputLocalIndex++] = 0x400000;
        }
    }

    private int getLocal(int localIndex) {
        if (this.outputLocals == null || localIndex >= this.outputLocals.length) {
            return 0x1000000 | localIndex;
        }
        int abstractType = this.outputLocals[localIndex];
        if (abstractType == 0) {
            abstractType = this.outputLocals[localIndex] = 0x1000000 | localIndex;
        }
        return abstractType;
    }

    private void setLocal(int localIndex, int abstractType) {
        int outputLocalsLength;
        if (this.outputLocals == null) {
            this.outputLocals = new int[10];
        }
        if (localIndex >= (outputLocalsLength = this.outputLocals.length)) {
            int[] newOutputLocals = new int[Math.max(localIndex + 1, 2 * outputLocalsLength)];
            System.arraycopy(this.outputLocals, 0, newOutputLocals, 0, outputLocalsLength);
            this.outputLocals = newOutputLocals;
        }
        this.outputLocals[localIndex] = abstractType;
    }

    private void push(int abstractType) {
        int outputStackLength;
        if (this.outputStack == null) {
            this.outputStack = new int[10];
        }
        if (this.outputStackTop >= (outputStackLength = this.outputStack.length)) {
            int[] newOutputStack = new int[Math.max(this.outputStackTop + 1, 2 * outputStackLength)];
            System.arraycopy(this.outputStack, 0, newOutputStack, 0, outputStackLength);
            this.outputStack = newOutputStack;
        }
        short s = this.outputStackTop;
        this.outputStackTop = (short)(s + 1);
        this.outputStack[s] = abstractType;
        short outputStackSize = (short)(this.outputStackStart + this.outputStackTop);
        if (outputStackSize > this.owner.outputStackMax) {
            this.owner.outputStackMax = outputStackSize;
        }
    }

    private void push(SymbolTable symbolTable, String descriptor) {
        int typeDescriptorOffset;
        switch (descriptor) {
            case "()J": 
            case "()V": 
            case "()Z": 
            case "()I": 
            case "()Ljava/lang/Class;": {
                typeDescriptorOffset = 2;
                break;
            }
            case "(I)V": 
            case "(J)V": 
            case "(J)Z": 
            case "(I)Ljava/lang/Object;": 
            case "(I)Ljava/lang/Integer;": {
                typeDescriptorOffset = 3;
                break;
            }
            case "(Ljava/lang/Enum;)V": {
                typeDescriptorOffset = 18;
                break;
            }
            case "(Ljava/lang/Object;)Z": 
            case "(Ljava/lang/String;)V": 
            case "(Ljava/lang/Object;)V": {
                typeDescriptorOffset = 20;
                break;
            }
            case "(Lcom/alibaba/fastjson2/JSONWriter;)V": 
            case "(Lcom/alibaba/fastjson2/JSONWriter;)Z": {
                typeDescriptorOffset = 36;
                break;
            }
            case "(Lcom/alibaba/fastjson2/JSONWriter;I)V": 
            case "(Lcom/alibaba/fastjson2/JSONWriter;J)V": {
                typeDescriptorOffset = 37;
                break;
            }
            case "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Z": {
                typeDescriptorOffset = 44;
                break;
            }
            case "(Lcom/alibaba/fastjson2/JSONWriter;Ljava/lang/Enum;)V": {
                typeDescriptorOffset = 52;
                break;
            }
            case "(Lcom/alibaba/fastjson2/JSONWriter;Ljava/lang/Class;)Lcom/alibaba/fastjson2/writer/ObjectWriter;": 
            case "(Lcom/alibaba/fastjson2/JSONWriter;ZLjava/util/List;)V": {
                typeDescriptorOffset = 53;
                break;
            }
            case "(Lcom/alibaba/fastjson2/JSONWriter;Ljava/lang/reflect/Type;)Lcom/alibaba/fastjson2/writer/ObjectWriter;": {
                typeDescriptorOffset = 60;
                break;
            }
            case "(Lcom/alibaba/fastjson2/writer/FieldWriter;Ljava/lang/Object;)Ljava/lang/String;": {
                typeDescriptorOffset = 62;
                break;
            }
            case "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;JLjava/util/List;)V": {
                typeDescriptorOffset = 72;
                break;
            }
            case "(Lcom/alibaba/fastjson2/JSONWriter;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;J)V": {
                typeDescriptorOffset = 97;
                break;
            }
            default: {
                if (descriptor.charAt(0) == '(') {
                    int currentOffset = 1;
                    while (descriptor.charAt(currentOffset) != ')') {
                        while (descriptor.charAt(currentOffset) == '[') {
                            ++currentOffset;
                        }
                        if (descriptor.charAt(currentOffset++) != 'L') continue;
                        int semiColumnOffset = descriptor.indexOf(59, currentOffset);
                        currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
                    }
                    typeDescriptorOffset = currentOffset + 1;
                    break;
                }
                typeDescriptorOffset = 0;
            }
        }
        int abstractType = Frame.getAbstractTypeFromDescriptor(symbolTable, descriptor, typeDescriptorOffset);
        if (abstractType != 0) {
            this.push(abstractType);
            if (abstractType == 0x400004 || abstractType == 0x400003) {
                this.push(0x400000);
            }
        }
    }

    private int pop() {
        if (this.outputStackTop > 0) {
            this.outputStackTop = (short)(this.outputStackTop - 1);
            return this.outputStack[this.outputStackTop];
        }
        this.outputStackStart = (short)(this.outputStackStart - 1);
        return 0x1400000 | -this.outputStackStart;
    }

    private void pop(int elements) {
        if (this.outputStackTop >= elements) {
            this.outputStackTop = (short)(this.outputStackTop - elements);
        } else {
            this.outputStackStart = (short)(this.outputStackStart - (elements - this.outputStackTop));
            this.outputStackTop = 0;
        }
    }

    private void pop(String descriptor) {
        char firstDescriptorChar = descriptor.charAt(0);
        if (firstDescriptorChar == '(') {
            this.pop((Type.getArgumentsAndReturnSizes(descriptor) >> 2) - 1);
        } else if (firstDescriptorChar == 'J' || firstDescriptorChar == 'D') {
            this.pop(2);
        } else {
            this.pop(1);
        }
    }

    private void addInitializedType(int abstractType) {
        int initializationsLength;
        if (this.initializations == null) {
            this.initializations = new int[2];
        }
        if (this.initializationCount >= (initializationsLength = this.initializations.length)) {
            int[] newInitializations = new int[Math.max(this.initializationCount + 1, 2 * initializationsLength)];
            System.arraycopy(this.initializations, 0, newInitializations, 0, initializationsLength);
            this.initializations = newInitializations;
        }
        this.initializations[this.initializationCount++] = abstractType;
    }

    private int getInitializedType(SymbolTable symbolTable, int abstractType) {
        if (abstractType == 0x400006 || (abstractType & 0xFFC00000) == 0xC00000) {
            for (int i = 0; i < this.initializationCount; ++i) {
                int initializedType = this.initializations[i];
                int dim = initializedType & 0xFC000000;
                int kind = initializedType & 0x3C00000;
                int value = initializedType & 0xFFFFF;
                if (kind == 0x1000000) {
                    initializedType = dim + this.inputLocals[value];
                } else if (kind == 0x1400000) {
                    initializedType = dim + this.inputStack[this.inputStack.length - value];
                }
                if (abstractType != initializedType) continue;
                if (abstractType == 0x400006) {
                    return 0x800000 | symbolTable.addType(symbolTable.className);
                }
                return 0x800000 | symbolTable.addType(symbolTable.typeTable[abstractType & 0xFFFFF].value);
            }
        }
        return abstractType;
    }

    void execute(int opcode, int arg, Symbol argSymbol, SymbolTable symbolTable) {
        int CONSTANT_INTEGER_TAG = 3;
        int CONSTANT_FLOAT_TAG = 4;
        int CONSTANT_LONG_TAG = 5;
        int CONSTANT_DOUBLE_TAG = 6;
        int CONSTANT_CLASS_TAG = 7;
        int CONSTANT_STRING_TAG = 8;
        int CONSTANT_METHOD_HANDLE_TAG = 15;
        int CONSTANT_METHOD_TYPE_TAG = 16;
        int CONSTANT_DYNAMIC_TAG = 17;
        block0 : switch (opcode) {
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 177: {
                break;
            }
            case 1: {
                this.push(0x400005);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: {
                this.push(0x400001);
                break;
            }
            case 9: 
            case 10: 
            case 22: {
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                this.push(0x400002);
                break;
            }
            case 14: 
            case 15: 
            case 24: {
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 18: {
                switch (argSymbol.tag) {
                    case 3: {
                        this.push(0x400001);
                        break block0;
                    }
                    case 5: {
                        this.push(0x400004);
                        this.push(0x400000);
                        break block0;
                    }
                    case 4: {
                        this.push(0x400002);
                        break block0;
                    }
                    case 6: {
                        this.push(0x400003);
                        this.push(0x400000);
                        break block0;
                    }
                    case 7: {
                        this.push(0x800000 | symbolTable.addType("java/lang/Class"));
                        break block0;
                    }
                    case 8: {
                        this.push(0x800000 | symbolTable.addType("java/lang/String"));
                        break block0;
                    }
                    case 16: {
                        this.push(0x800000 | symbolTable.addType("java/lang/invoke/MethodType"));
                        break block0;
                    }
                    case 15: {
                        this.push(0x800000 | symbolTable.addType("java/lang/invoke/MethodHandle"));
                        break block0;
                    }
                    case 17: {
                        this.push(symbolTable, argSymbol.value);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case 25: {
                this.push(this.getLocal(arg));
                break;
            }
            case 47: 
            case 143: {
                this.pop(2);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 50: {
                this.pop(1);
                int abstractType1 = this.pop();
                this.push(abstractType1 == 0x400005 ? abstractType1 : -67108864 + abstractType1);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                int abstractType1 = this.pop();
                this.setLocal(arg, abstractType1);
                if (arg <= 0) break;
                int previousLocalType = this.getLocal(arg - 1);
                if (previousLocalType == 0x400004 || previousLocalType == 0x400003) {
                    this.setLocal(arg - 1, 0x400000);
                    break;
                }
                if ((previousLocalType & 0x3C00000) != 0x1000000 && (previousLocalType & 0x3C00000) != 0x1400000) break;
                this.setLocal(arg - 1, previousLocalType | 0x100000);
                break;
            }
            case 55: 
            case 57: {
                this.pop(1);
                int abstractType1 = this.pop();
                this.setLocal(arg, abstractType1);
                this.setLocal(arg + 1, 0x400000);
                if (arg <= 0) break;
                int previousLocalType = this.getLocal(arg - 1);
                if (previousLocalType == 0x400004 || previousLocalType == 0x400003) {
                    this.setLocal(arg - 1, 0x400000);
                    break;
                }
                if ((previousLocalType & 0x3C00000) != 0x1000000 && (previousLocalType & 0x3C00000) != 0x1400000) break;
                this.setLocal(arg - 1, previousLocalType | 0x100000);
                break;
            }
            case 87: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                this.pop(1);
                break;
            }
            case 88: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 89: {
                int abstractType1 = this.pop();
                this.push(abstractType1);
                this.push(abstractType1);
                break;
            }
            case 92: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                this.push(abstractType2);
                this.push(abstractType1);
                this.push(abstractType2);
                this.push(abstractType1);
                break;
            }
            case 95: {
                int abstractType1 = this.pop();
                int abstractType2 = this.pop();
                this.push(abstractType1);
                this.push(abstractType2);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 142: 
            case 149: 
            case 150: {
                this.pop(2);
                this.push(0x400001);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(4);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop(3);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 132: {
                this.setLocal(arg, 0x400001);
                break;
            }
            case 139: 
            case 190: 
            case 193: {
                this.pop(1);
                this.push(0x400001);
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(4);
                this.push(0x400001);
                break;
            }
            case 178: {
                this.push(symbolTable, argSymbol.value);
                break;
            }
            case 179: {
                this.pop(argSymbol.value);
                break;
            }
            case 180: {
                this.pop(1);
                this.push(symbolTable, argSymbol.value);
                break;
            }
            case 181: {
                this.pop(argSymbol.value);
                this.pop();
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.pop(argSymbol.value);
                if (opcode != 184) {
                    int abstractType1 = this.pop();
                    if (opcode == 183 && argSymbol.name.charAt(0) == '<') {
                        this.addInitializedType(abstractType1);
                    }
                }
                this.push(symbolTable, argSymbol.value);
                break;
            }
            case 187: {
                this.push(0xC00000 | symbolTable.addUninitializedType(argSymbol.value, arg));
                break;
            }
            case 192: {
                String castType = argSymbol.value;
                this.pop();
                if (castType.charAt(0) == '[') {
                    this.push(symbolTable, castType);
                    break;
                }
                this.push(0x800000 | symbolTable.addType(castType));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private int getConcreteOutputType(int abstractOutputType, int numStack) {
        int dim = abstractOutputType & 0xFC000000;
        int kind = abstractOutputType & 0x3C00000;
        if (kind == 0x1000000) {
            int concreteOutputType = dim + this.inputLocals[abstractOutputType & 0xFFFFF];
            if ((abstractOutputType & 0x100000) != 0 && (concreteOutputType == 0x400004 || concreteOutputType == 0x400003)) {
                concreteOutputType = 0x400000;
            }
            return concreteOutputType;
        }
        if (kind == 0x1400000) {
            int concreteOutputType = dim + this.inputStack[numStack - (abstractOutputType & 0xFFFFF)];
            if ((abstractOutputType & 0x100000) != 0 && (concreteOutputType == 0x400004 || concreteOutputType == 0x400003)) {
                concreteOutputType = 0x400000;
            }
            return concreteOutputType;
        }
        return abstractOutputType;
    }

    final boolean merge(SymbolTable symbolTable, Frame dstFrame) {
        int i;
        int abstractOutputType;
        int numLocal = this.inputLocals.length;
        int numStack = this.inputStack.length;
        boolean frameChanged = dstFrame.inputLocals == null;
        if (frameChanged) {
            dstFrame.inputLocals = new int[numLocal];
        }
        for (int i2 = 0; i2 < numLocal; ++i2) {
            int concreteOutputType = this.outputLocals != null && i2 < this.outputLocals.length ? ((abstractOutputType = this.outputLocals[i2]) == 0 ? this.inputLocals[i2] : this.getConcreteOutputType(abstractOutputType, numStack)) : this.inputLocals[i2];
            if (this.initializations != null) {
                concreteOutputType = this.getInitializedType(symbolTable, concreteOutputType);
            }
            frameChanged |= Frame.merge(symbolTable, concreteOutputType, dstFrame.inputLocals, i2);
        }
        int numInputStack = this.inputStack.length + this.outputStackStart;
        if (dstFrame.inputStack == null) {
            dstFrame.inputStack = new int[numInputStack + this.outputStackTop];
            frameChanged = true;
        }
        for (i = 0; i < numInputStack; ++i) {
            int concreteOutputType = this.inputStack[i];
            if (this.initializations != null) {
                concreteOutputType = this.getInitializedType(symbolTable, concreteOutputType);
            }
            frameChanged |= Frame.merge(symbolTable, concreteOutputType, dstFrame.inputStack, i);
        }
        for (i = 0; i < this.outputStackTop; ++i) {
            abstractOutputType = this.outputStack[i];
            int concreteOutputType = this.getConcreteOutputType(abstractOutputType, numStack);
            if (this.initializations != null) {
                concreteOutputType = this.getInitializedType(symbolTable, concreteOutputType);
            }
            frameChanged |= Frame.merge(symbolTable, concreteOutputType, dstFrame.inputStack, numInputStack + i);
        }
        return frameChanged;
    }

    private static boolean merge(SymbolTable symbolTable, int sourceType, int[] dstTypes, int dstIndex) {
        int mergedType;
        int dstType = dstTypes[dstIndex];
        if (dstType == sourceType) {
            return false;
        }
        int srcType = sourceType;
        if ((sourceType & 0x3FFFFFF) == 0x400005) {
            if (dstType == 0x400005) {
                return false;
            }
            srcType = 0x400005;
        }
        if (dstType == 0) {
            dstTypes[dstIndex] = srcType;
            return true;
        }
        String TYPE_JAVA_OBJECT = "java/lang/Object";
        if ((dstType & 0xFC000000) != 0 || (dstType & 0x3C00000) == 0x800000) {
            if (srcType == 0x400005) {
                return false;
            }
            if ((srcType & 0xFFC00000) == (dstType & 0xFFC00000)) {
                if ((dstType & 0x3C00000) == 0x800000) {
                    mergedType = srcType & 0xFC000000 | 0x800000 | symbolTable.addMergedType(srcType & 0xFFFFF, dstType & 0xFFFFF);
                } else {
                    int mergedDim = -67108864 + (srcType & 0xFC000000);
                    mergedType = mergedDim | 0x800000 | symbolTable.addType("java/lang/Object");
                }
            } else if ((srcType & 0xFC000000) != 0 || (srcType & 0x3C00000) == 0x800000) {
                int dstDim;
                int srcDim = srcType & 0xFC000000;
                if (srcDim != 0 && (srcType & 0x3C00000) != 0x800000) {
                    srcDim = -67108864 + srcDim;
                }
                if ((dstDim = dstType & 0xFC000000) != 0 && (dstType & 0x3C00000) != 0x800000) {
                    dstDim = -67108864 + dstDim;
                }
                mergedType = Math.min(srcDim, dstDim) | 0x800000 | symbolTable.addType("java/lang/Object");
            } else {
                mergedType = 0x400000;
            }
        } else {
            int n = mergedType = dstType == 0x400005 && ((srcType & 0xFC000000) != 0 || (srcType & 0x3C00000) == 0x800000) ? srcType : 0x400000;
        }
        if (mergedType != dstType) {
            dstTypes[dstIndex] = mergedType;
            return true;
        }
        return false;
    }

    final void accept(MethodWriter methodWriter) {
        int[] localTypes = this.inputLocals;
        int numLocal = 0;
        int numTrailingTop = 0;
        int i = 0;
        while (i < localTypes.length) {
            int localType;
            i += (localType = localTypes[i]) == 0x400004 || localType == 0x400003 ? 2 : 1;
            if (localType == 0x400000) {
                ++numTrailingTop;
                continue;
            }
            numLocal += numTrailingTop + 1;
            numTrailingTop = 0;
        }
        int[] stackTypes = this.inputStack;
        int numStack = 0;
        i = 0;
        while (i < stackTypes.length) {
            int stackType;
            i += (stackType = stackTypes[i]) == 0x400004 || stackType == 0x400003 ? 2 : 1;
            ++numStack;
        }
        int frameIndex = methodWriter.visitFrameStart(this.owner.bytecodeOffset, numLocal, numStack);
        i = 0;
        while (numLocal-- > 0) {
            int localType;
            i += (localType = localTypes[i]) == 0x400004 || localType == 0x400003 ? 2 : 1;
            methodWriter.visitAbstractType(frameIndex++, localType);
        }
        i = 0;
        while (numStack-- > 0) {
            int stackType;
            i += (stackType = stackTypes[i]) == 0x400004 || stackType == 0x400003 ? 2 : 1;
            methodWriter.visitAbstractType(frameIndex++, stackType);
        }
        methodWriter.visitFrameEnd();
    }
}

