/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.writer;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.filter.Filter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.Fnv;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public interface ObjectWriter<T> {
    default public long getFeatures() {
        return 0L;
    }

    default public List<FieldWriter> getFieldWriters() {
        return Collections.emptyList();
    }

    default public FieldWriter getFieldWriter(long hashCode) {
        return null;
    }

    default public Object getFieldValue(Object object, String fieldName) {
        FieldWriter fieldWriter = this.getFieldWriter(fieldName);
        if (fieldWriter == null) {
            return null;
        }
        return fieldWriter.getFieldValue(object);
    }

    default public FieldWriter getFieldWriter(String name) {
        long nameHashLCase;
        long nameHash = Fnv.hashCode64(name);
        FieldWriter fieldWriter = this.getFieldWriter(nameHash);
        if (fieldWriter == null && (nameHashLCase = Fnv.hashCode64LCase(name)) != nameHash) {
            fieldWriter = this.getFieldWriter(nameHashLCase);
        }
        return fieldWriter;
    }

    default public boolean writeTypeInfo(JSONWriter jsonWriter) {
        return false;
    }

    default public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        this.write(jsonWriter, object, fieldName, fieldType, features);
    }

    default public void writeArrayMappingJSONB(JSONWriter jsonWriter, Object object) {
        this.writeArrayMappingJSONB(jsonWriter, object, null, null, 0L);
    }

    default public void writeArrayMappingJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        List<FieldWriter> fieldWriters = this.getFieldWriters();
        int size = fieldWriters.size();
        jsonWriter.startArray(size);
        for (int i = 0; i < size; ++i) {
            FieldWriter fieldWriter = fieldWriters.get(i);
            fieldWriter.writeValue(jsonWriter, object);
        }
    }

    default public void writeArrayMapping(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.jsonb) {
            this.writeArrayMappingJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        List<FieldWriter> fieldWriters = this.getFieldWriters();
        jsonWriter.startArray();
        boolean hasFilter = this.hasFilter(jsonWriter);
        if (!hasFilter) {
            int size = fieldWriters.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    jsonWriter.writeComma();
                }
                FieldWriter fieldWriter = fieldWriters.get(i);
                fieldWriter.writeValue(jsonWriter, object);
            }
        } else {
            JSONWriter.Context ctx = jsonWriter.context;
            PropertyPreFilter propertyPreFilter = ctx.getPropertyPreFilter();
            ValueFilter valueFilter = ctx.getValueFilter();
            PropertyFilter propertyFilter = ctx.getPropertyFilter();
            int size = fieldWriters.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    jsonWriter.writeComma();
                }
                FieldWriter fieldWriter = fieldWriters.get(i);
                if (propertyPreFilter != null && !propertyPreFilter.process(jsonWriter, object, fieldWriter.fieldName)) {
                    jsonWriter.writeNull();
                    continue;
                }
                Object fieldValue = fieldWriter.getFieldValue(object);
                if (propertyFilter != null && !propertyFilter.apply(object, fieldWriter.fieldName, fieldValue)) {
                    jsonWriter.writeNull();
                    continue;
                }
                if (valueFilter != null) {
                    Object processValue = valueFilter.apply(object, fieldWriter.fieldName, fieldValue);
                    if (processValue == null) {
                        jsonWriter.writeNull();
                        continue;
                    }
                    ObjectWriter processValueWriter = fieldWriter.getObjectWriter(jsonWriter, processValue.getClass());
                    processValueWriter.write(jsonWriter, fieldValue);
                    continue;
                }
                if (fieldValue == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                ObjectWriter fieldValueWriter = fieldWriter.getObjectWriter(jsonWriter, fieldValue.getClass());
                fieldValueWriter.write(jsonWriter, fieldValue);
            }
        }
        jsonWriter.endArray();
    }

    default public boolean hasFilter(JSONWriter jsonWriter) {
        return jsonWriter.hasFilter(JSONWriter.Feature.IgnoreNonFieldGetter.mask);
    }

    default public void write(JSONWriter jsonWriter, Object object) {
        this.write(jsonWriter, object, null, null, 0L);
    }

    default public String toJSONString(T object, JSONWriter.Feature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of(features);){
            this.write(jsonWriter, object, null, null, 0L);
            String string = jsonWriter.toString();
            return string;
        }
    }

    public void write(JSONWriter var1, Object var2, Object var3, Type var4, long var5);

    default public void writeWithFilter(JSONWriter jsonWriter, Object object) {
        this.writeWithFilter(jsonWriter, object, null, null, 0L);
    }

    default public void writeWithFilter(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        throw new UnsupportedOperationException();
    }

    default public void setPropertyFilter(PropertyFilter propertyFilter) {
    }

    default public void setValueFilter(ValueFilter valueFilter) {
    }

    default public void setNameFilter(NameFilter nameFilter) {
    }

    default public void setPropertyPreFilter(PropertyPreFilter propertyPreFilter) {
    }

    default public void setFilter(Filter filter) {
        if (filter instanceof PropertyFilter) {
            this.setPropertyFilter((PropertyFilter)filter);
        }
        if (filter instanceof ValueFilter) {
            this.setValueFilter((ValueFilter)filter);
        }
        if (filter instanceof NameFilter) {
            this.setNameFilter((NameFilter)filter);
        }
        if (filter instanceof PropertyPreFilter) {
            this.setPropertyPreFilter((PropertyPreFilter)filter);
        }
    }
}

