/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.ZipFile;

public class IOUtils {
    private IOUtils() {
    }

    public static String toString(InputStream inputStream) throws IOException {
        int length;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        IOUtils.copy(input, result);
        result.close();
        return result.toByteArray();
    }

    public static IOException close(InputStream input) {
        return IOUtils.close((Closeable)input);
    }

    public static IOException close(OutputStream output) {
        return IOUtils.close((Closeable)output);
    }

    public static IOException close(Reader input) {
        return IOUtils.close((Closeable)input);
    }

    public static IOException close(Writer output) {
        return IOUtils.close((Closeable)output);
    }

    public static IOException close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            return ioe;
        }
        return null;
    }

    public static IOException close(ZipFile zip) {
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (IOException ioe) {
            return ioe;
        }
        return null;
    }
}

