/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.command.model.ThreadVO;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.management.HotspotThreadMBean;
import sun.management.ManagementFactoryHelper;

public class ThreadSampler {
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static HotspotThreadMBean hotspotThreadMBean;
    private static boolean hotspotThreadMBeanEnable;
    private Map<ThreadVO, Long> lastCpuTimes = new HashMap<ThreadVO, Long>();
    private long lastSampleTimeNanos;
    private boolean includeInternalThreads = true;

    public List<ThreadVO> sample(Collection<ThreadVO> originThreads) {
        ArrayList<ThreadVO> threads = new ArrayList<ThreadVO>(originThreads);
        if (this.lastCpuTimes.isEmpty()) {
            this.lastSampleTimeNanos = System.nanoTime();
            for (ThreadVO thread : threads) {
                if (thread.getId() <= 0L) continue;
                long cpu = threadMXBean.getThreadCpuTime(thread.getId());
                this.lastCpuTimes.put(thread, cpu);
                thread.setTime(cpu / 1000000L);
            }
            Map<String, Long> internalThreadCpuTimes = this.getInternalThreadCpuTimes();
            if (internalThreadCpuTimes != null) {
                for (Map.Entry<String, Long> entry : internalThreadCpuTimes.entrySet()) {
                    String key = entry.getKey();
                    ThreadVO threadVO = this.createThreadVO(key);
                    threadVO.setTime(entry.getValue() / 1000000L);
                    threads.add(threadVO);
                    this.lastCpuTimes.put(threadVO, entry.getValue());
                }
            }
            Collections.sort(threads, new Comparator<ThreadVO>(){

                @Override
                public int compare(ThreadVO o1, ThreadVO o2) {
                    long l2;
                    long l1 = o1.getTime();
                    if (l1 < (l2 = o2.getTime())) {
                        return 1;
                    }
                    if (l1 > l2) {
                        return -1;
                    }
                    return 0;
                }
            });
            return threads;
        }
        long newSampleTimeNanos = System.nanoTime();
        HashMap<ThreadVO, Long> newCpuTimes = new HashMap<ThreadVO, Long>(threads.size());
        for (ThreadVO threadVO : threads) {
            if (threadVO.getId() <= 0L) continue;
            long l = threadMXBean.getThreadCpuTime(threadVO.getId());
            newCpuTimes.put(threadVO, l);
        }
        Map<String, Long> newInternalThreadCpuTimes = this.getInternalThreadCpuTimes();
        if (newInternalThreadCpuTimes != null) {
            for (Map.Entry<String, Long> entry : newInternalThreadCpuTimes.entrySet()) {
                ThreadVO threadVO = this.createThreadVO(entry.getKey());
                threads.add(threadVO);
                newCpuTimes.put(threadVO, entry.getValue());
            }
        }
        final HashMap<ThreadVO, Long> hashMap = new HashMap<ThreadVO, Long>(threads.size());
        for (ThreadVO thread : newCpuTimes.keySet()) {
            Long t = this.lastCpuTimes.get(thread);
            if (t == null) {
                t = 0L;
            }
            long time1 = t;
            long time2 = (Long)newCpuTimes.get(thread);
            if (time1 == -1L) {
                time1 = time2;
            } else if (time2 == -1L) {
                time2 = time1;
            }
            long delta = time2 - time1;
            hashMap.put(thread, delta);
        }
        long l = newSampleTimeNanos - this.lastSampleTimeNanos;
        HashMap<ThreadVO, Double> cpuUsages = new HashMap<ThreadVO, Double>(threads.size());
        for (ThreadVO thread : threads) {
            double cpu = l == 0L ? 0.0 : Math.rint((double)((Long)hashMap.get(thread)).longValue() * 10000.0 / (double)l) / 100.0;
            cpuUsages.put(thread, cpu);
        }
        Collections.sort(threads, new Comparator<ThreadVO>(){

            @Override
            public int compare(ThreadVO o1, ThreadVO o2) {
                long l2;
                long l1 = (Long)hashMap.get(o1);
                if (l1 < (l2 = ((Long)hashMap.get(o2)).longValue())) {
                    return 1;
                }
                if (l1 > l2) {
                    return -1;
                }
                return 0;
            }
        });
        for (ThreadVO thread : threads) {
            long timeMills = (Long)newCpuTimes.get(thread) / 1000000L;
            long deltaTime = (Long)hashMap.get(thread) / 1000000L;
            double cpu = (Double)cpuUsages.get(thread);
            thread.setCpu(cpu);
            thread.setTime(timeMills);
            thread.setDeltaTime(deltaTime);
        }
        this.lastCpuTimes = newCpuTimes;
        this.lastSampleTimeNanos = newSampleTimeNanos;
        return threads;
    }

    private Map<String, Long> getInternalThreadCpuTimes() {
        if (hotspotThreadMBeanEnable && this.includeInternalThreads) {
            try {
                if (hotspotThreadMBean == null) {
                    hotspotThreadMBean = ManagementFactoryHelper.getHotspotThreadMBean();
                }
                return hotspotThreadMBean.getInternalThreadCpuTimes();
            }
            catch (Throwable e) {
                hotspotThreadMBeanEnable = false;
            }
        }
        return null;
    }

    private ThreadVO createThreadVO(String name) {
        ThreadVO threadVO = new ThreadVO();
        threadVO.setId(-1L);
        threadVO.setName(name);
        threadVO.setPriority(-1);
        threadVO.setDaemon(true);
        threadVO.setInterrupted(false);
        return threadVO;
    }

    public void pause(long mills) {
        try {
            Thread.sleep(mills);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIncludeInternalThreads() {
        return this.includeInternalThreads;
    }

    public void setIncludeInternalThreads(boolean includeInternalThreads) {
        this.includeInternalThreads = includeInternalThreads;
    }

    static {
        hotspotThreadMBeanEnable = true;
    }
}

