/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.history.impl;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.shell.history.HistoryManager;
import com.taobao.arthas.core.util.Constants;
import com.taobao.arthas.core.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class HistoryManagerImpl
implements HistoryManager {
    private static final int MAX_HISTORY_SIZE = 500;
    private static final Logger logger = LoggerFactory.getLogger(HistoryManagerImpl.class);
    private List<String> history = new ArrayList<String>();

    @Override
    public synchronized void saveHistory() {
        try {
            FileUtils.saveCommandHistoryString(this.history, new File(Constants.CMD_HISTORY_FILE));
        }
        catch (Throwable e) {
            logger.error("save command history failed", e);
        }
    }

    @Override
    public synchronized void loadHistory() {
        try {
            this.history = FileUtils.loadCommandHistoryString(new File(Constants.CMD_HISTORY_FILE));
        }
        catch (Throwable e) {
            logger.error("load command history failed", e);
        }
    }

    @Override
    public synchronized void clearHistory() {
        this.history.clear();
    }

    @Override
    public synchronized void addHistory(String commandLine) {
        while (this.history.size() >= 500) {
            this.history.remove(0);
        }
        this.history.add(commandLine);
    }

    @Override
    public synchronized List<String> getHistory() {
        return new ArrayList<String>(this.history);
    }

    @Override
    public synchronized void setHistory(List<String> history) {
        this.history = history;
    }
}

