/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.ssh.netty;

import com.alibaba.arthas.deps.io.netty.buffer.ByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.Unpooled;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPromise;
import com.alibaba.arthas.deps.io.netty.util.concurrent.Future;
import com.alibaba.arthas.deps.io.netty.util.concurrent.GenericFutureListener;
import io.termd.core.ssh.netty.NettyIoAcceptor;
import io.termd.core.ssh.netty.NettyIoWriteFuture;
import io.termd.core.util.Logging;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class NettyIoSession
extends AbstractCloseable
implements IoSession {
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final NettyIoAcceptor acceptor;
    private final IoHandler handler;
    private ChannelHandlerContext context;
    private SocketAddress remoteAddr;
    private ChannelFuture prev;
    private final DefaultCloseFuture closeFuture = new DefaultCloseFuture(null);
    private final long id;
    final ChannelInboundHandlerAdapter adapter = new ChannelInboundHandlerAdapter(){

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.context = ctx;
            ((NettyIoSession)NettyIoSession.this).acceptor.channelGroup.add(ctx.channel());
            ((NettyIoSession)NettyIoSession.this).acceptor.ioService.sessions.put(NettyIoSession.this.id, NettyIoSession.this);
            NettyIoSession.this.prev = NettyIoSession.this.context.newPromise().setSuccess();
            NettyIoSession.this.remoteAddr = NettyIoSession.this.context.channel().remoteAddress();
            ((NettyIoSession)NettyIoSession.this).acceptor.factory.handlerBridge.sessionCreated(NettyIoSession.this.handler, NettyIoSession.this);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ((NettyIoSession)NettyIoSession.this).acceptor.ioService.sessions.remove(NettyIoSession.this.id);
            ((NettyIoSession)NettyIoSession.this).acceptor.factory.handlerBridge.sessionClosed(NettyIoSession.this.handler, NettyIoSession.this);
            NettyIoSession.this.context = null;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf buf = (ByteBuf)msg;
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(0, bytes);
            ((NettyIoSession)NettyIoSession.this).acceptor.factory.handlerBridge.messageReceived(NettyIoSession.this.handler, NettyIoSession.this, (Readable)new ByteArrayBuffer(bytes));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Logging.logReportedIoError(cause);
            ctx.close();
        }
    };

    public NettyIoSession(NettyIoAcceptor acceptor, IoHandler handler) {
        this.acceptor = acceptor;
        this.handler = handler;
        this.id = acceptor.ioService.sessionSeq.incrementAndGet();
    }

    public void execute(Runnable task) {
        this.context.channel().eventLoop().execute(task);
    }

    public void schedule(Runnable task, long delay, TimeUnit unit) {
        this.context.channel().eventLoop().schedule(task, delay, unit);
    }

    public long getId() {
        return this.id;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public SocketAddress getLocalAddress() {
        return this.context.channel().localAddress();
    }

    public IoWriteFuture write(Buffer buffer) {
        final ByteBuf buf = Unpooled.buffer(buffer.available());
        buf.writeBytes(buffer.array(), buffer.rpos(), buffer.available());
        final NettyIoWriteFuture msg = new NettyIoWriteFuture();
        final ChannelPromise next = this.context.newPromise();
        this.prev.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                if (NettyIoSession.this.context != null) {
                    NettyIoSession.this.context.writeAndFlush(buf, next);
                }
            }
        });
        this.prev = next;
        next.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                if (future.isSuccess()) {
                    msg.setValue(Boolean.TRUE);
                } else {
                    msg.setValue(future.cause());
                }
            }
        });
        return msg;
    }

    public IoService getService() {
        return this.acceptor.ioService;
    }

    protected CloseFuture doCloseGracefully() {
        this.context.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE).addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                NettyIoSession.this.closeFuture.setClosed();
            }
        });
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.context.close();
        super.doCloseImmediately();
    }
}

