/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.telnet.netty;

import io.termd.core.function.Consumer;
import io.termd.core.function.Supplier;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.TelnetTtyConnection;
import io.termd.core.telnet.netty.NettyTelnetBootstrap;
import io.termd.core.tty.TtyConnection;
import io.termd.core.util.CompletableFuture;
import io.termd.core.util.Helper;
import java.nio.charset.Charset;

public class NettyTelnetTtyBootstrap {
    private final NettyTelnetBootstrap telnet;
    private boolean outBinary;
    private boolean inBinary;
    private Charset charset = Charset.forName("UTF-8");

    public NettyTelnetTtyBootstrap() {
        this.telnet = new NettyTelnetBootstrap();
    }

    public String getHost() {
        return this.telnet.getHost();
    }

    public NettyTelnetTtyBootstrap setHost(String host) {
        this.telnet.setHost(host);
        return this;
    }

    public int getPort() {
        return this.telnet.getPort();
    }

    public NettyTelnetTtyBootstrap setPort(int port) {
        this.telnet.setPort(port);
        return this;
    }

    public boolean isOutBinary() {
        return this.outBinary;
    }

    public NettyTelnetTtyBootstrap setOutBinary(boolean outBinary) {
        this.outBinary = outBinary;
        return this;
    }

    public boolean isInBinary() {
        return this.inBinary;
    }

    public NettyTelnetTtyBootstrap setInBinary(boolean inBinary) {
        this.inBinary = inBinary;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public CompletableFuture<?> start(Consumer<TtyConnection> factory) {
        CompletableFuture fut = new CompletableFuture();
        this.start(factory, Helper.startedHandler(fut));
        return fut;
    }

    public CompletableFuture<?> stop() {
        CompletableFuture fut = new CompletableFuture();
        this.stop(Helper.stoppedHandler(fut));
        return fut;
    }

    public void start(final Consumer<TtyConnection> factory, Consumer<Throwable> doneHandler) {
        this.telnet.start(new Supplier<TelnetHandler>(){

            @Override
            public TelnetHandler get() {
                return new TelnetTtyConnection(NettyTelnetTtyBootstrap.this.inBinary, NettyTelnetTtyBootstrap.this.outBinary, NettyTelnetTtyBootstrap.this.charset, factory);
            }
        }, doneHandler);
    }

    public void stop(Consumer<Throwable> doneHandler) {
        this.telnet.stop(doneHandler);
    }
}

