/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.util.Parser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAL10NResourceBundle
extends ResourceBundle {
    static long CHECK_DELAY = 600000L;
    Map<String, String> map = new ConcurrentHashMap<String, String>();
    File hostFile;
    volatile long nextCheck;
    long lastModified;
    CAL10NResourceBundle parent;

    public CAL10NResourceBundle(Reader r, File file2) throws IOException {
        this.read(r);
        this.hostFile = file2;
        this.nextCheck = System.currentTimeMillis() + CHECK_DELAY;
    }

    void read(Reader r) throws IOException {
        Parser p = new Parser(r, this.map);
        p.parseAndPopulate();
    }

    public void setParent(CAL10NResourceBundle parent) {
        this.parent = parent;
    }

    public boolean hasChanged() {
        if (this.hostFile == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextCheck) {
            return false;
        }
        this.nextCheck = now + CHECK_DELAY;
        if (this.lastModified != this.hostFile.lastModified()) {
            this.lastModified = this.hostFile.lastModified();
            return true;
        }
        return false;
    }

    public void resetCheckTimes() {
        this.nextCheck = 0L;
        this.lastModified = 0L;
    }

    @Override
    public Enumeration<String> getKeys() {
        Hashtable<String, String> ht = new Hashtable<String, String>(this.map);
        if (this.parent != null) {
            ht.putAll(this.parent.map);
        }
        return ht.keys();
    }

    @Override
    protected Object handleGetObject(String key2) {
        if (key2 == null) {
            throw new NullPointerException();
        }
        Object o = this.map.get(key2);
        if (o == null && this.parent != null) {
            o = this.parent.handleGetObject(key2);
        }
        return o;
    }
}

