/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.file;

import cn.hutool.cache.Cache;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import java.io.File;
import java.io.Serializable;

public abstract class AbstractFileCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int capacity;
    protected final int maxFileSize;
    protected final long timeout;
    protected final Cache<File, byte[]> cache;
    protected int usedSize;

    public AbstractFileCache(int capacity, int maxFileSize, long timeout) {
        this.capacity = capacity;
        this.maxFileSize = maxFileSize;
        this.timeout = timeout;
        this.cache = this.initCache();
    }

    public int capacity() {
        return this.capacity;
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int maxFileSize() {
        return this.maxFileSize;
    }

    public int getCachedFilesCount() {
        return this.cache.size();
    }

    public long timeout() {
        return this.timeout;
    }

    public void clear() {
        this.cache.clear();
        this.usedSize = 0;
    }

    public byte[] getFileBytes(String path2) throws IORuntimeException {
        return this.getFileBytes(new File(path2));
    }

    public byte[] getFileBytes(File file2) throws IORuntimeException {
        byte[] bytes2 = this.cache.get(file2);
        if (bytes2 != null) {
            return bytes2;
        }
        bytes2 = FileUtil.readBytes(file2);
        if (this.maxFileSize != 0 && file2.length() > (long)this.maxFileSize) {
            return bytes2;
        }
        this.usedSize += bytes2.length;
        this.cache.put(file2, bytes2);
        return bytes2;
    }

    protected abstract Cache<File, byte[]> initCache();
}

