/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean.copier;

import cn.hutool.core.lang.Editor;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.BiPredicate;

public class CopyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> editable;
    protected boolean ignoreNullValue;
    protected BiPredicate<Field, Object> propertiesFilter;
    protected String[] ignoreProperties;
    protected boolean ignoreError;
    protected boolean ignoreCase;
    protected Map<String, String> fieldMapping;
    private Map<String, String> reversedFieldMapping;
    protected Editor<String> fieldNameEditor;
    private boolean transientSupport = true;

    public static CopyOptions create() {
        return new CopyOptions();
    }

    public static CopyOptions create(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
        return new CopyOptions(editable, ignoreNullValue, ignoreProperties);
    }

    public CopyOptions() {
    }

    public CopyOptions(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
        this.propertiesFilter = (f, v) -> true;
        this.editable = editable;
        this.ignoreNullValue = ignoreNullValue;
        this.ignoreProperties = ignoreProperties;
    }

    public CopyOptions setEditable(Class<?> editable) {
        this.editable = editable;
        return this;
    }

    public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
        this.ignoreNullValue = ignoreNullVall;
        return this;
    }

    public CopyOptions ignoreNullValue() {
        return this.setIgnoreNullValue(true);
    }

    public CopyOptions setPropertiesFilter(BiPredicate<Field, Object> propertiesFilter) {
        this.propertiesFilter = propertiesFilter;
        return this;
    }

    public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
        return this;
    }

    public CopyOptions setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public CopyOptions ignoreError() {
        return this.setIgnoreError(true);
    }

    public CopyOptions setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public CopyOptions ignoreCase() {
        return this.setIgnoreCase(true);
    }

    public CopyOptions setFieldMapping(Map<String, String> fieldMapping) {
        this.fieldMapping = fieldMapping;
        return this;
    }

    public CopyOptions setFieldNameEditor(Editor<String> fieldNameEditor) {
        this.fieldNameEditor = fieldNameEditor;
        return this;
    }

    public boolean isTransientSupport() {
        return this.transientSupport;
    }

    public CopyOptions setTransientSupport(boolean transientSupport) {
        this.transientSupport = transientSupport;
        return this;
    }

    protected String getMappedFieldName(String fieldName, boolean reversed) {
        Map<String, String> mapping;
        Map<String, String> map2 = mapping = reversed ? this.getReversedMapping() : this.fieldMapping;
        if (MapUtil.isEmpty(mapping)) {
            return fieldName;
        }
        return ObjectUtil.defaultIfNull(mapping.get(fieldName), fieldName);
    }

    protected String editFieldName(String fieldName) {
        return null != this.fieldNameEditor ? this.fieldNameEditor.edit(fieldName) : fieldName;
    }

    private Map<String, String> getReversedMapping() {
        if (null == this.fieldMapping) {
            return null;
        }
        if (null == this.reversedFieldMapping) {
            this.reversedFieldMapping = MapUtil.reverse(this.fieldMapping);
        }
        return this.reversedFieldMapping;
    }
}

