/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class NullComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final boolean nullGreater;
    protected final Comparator<T> comparator;

    public NullComparator(boolean nullGreater, Comparator<? super T> comparator2) {
        this.nullGreater = nullGreater;
        this.comparator = comparator2;
    }

    @Override
    public int compare(T a, T b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return this.nullGreater ? 1 : -1;
        }
        if (b == null) {
            return this.nullGreater ? -1 : 1;
        }
        return this.doCompare(a, b);
    }

    @Override
    public Comparator<T> thenComparing(Comparator<? super T> other) {
        Objects.requireNonNull(other);
        return new NullComparator<T>(this.nullGreater, this.comparator == null ? other : this.comparator.thenComparing(other));
    }

    @Override
    public Comparator<T> reversed() {
        return new NullComparator<T>(false == this.nullGreater, this.comparator == null ? null : this.comparator.reversed());
    }

    protected int doCompare(T a, T b) {
        if (null == this.comparator) {
            if (a instanceof Comparable && b instanceof Comparable) {
                return ((Comparable)a).compareTo(b);
            }
            return 0;
        }
        return this.comparator.compare(a, b);
    }
}

