/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compiler;

import cn.hutool.core.compiler.JavaSourceFileObject;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public class JavaFileObjectUtil {
    public static List<JavaFileObject> getJavaFileObjects(File file2) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        String fileName = file2.getName();
        if (JavaFileObjectUtil.isJavaFile(fileName)) {
            result.add(new JavaSourceFileObject(file2.toURI()));
        } else if (JavaFileObjectUtil.isJarOrZipFile(fileName)) {
            result.addAll(JavaFileObjectUtil.getJavaFileObjectByZipOrJarFile(file2));
        }
        return result;
    }

    public static boolean isJarOrZipFile(String fileName) {
        return FileNameUtil.isType(fileName, "jar", "zip");
    }

    public static boolean isJavaFile(String fileName) {
        return FileNameUtil.isType(fileName, "java");
    }

    private static List<JavaFileObject> getJavaFileObjectByZipOrJarFile(File file2) {
        ArrayList<JavaFileObject> collection = new ArrayList<JavaFileObject>();
        ZipFile zipFile = ZipUtil.toZipFile(file2, null);
        ZipUtil.read(zipFile, zipEntry -> {
            String name2 = zipEntry.getName();
            if (JavaFileObjectUtil.isJavaFile(name2)) {
                collection.add(new JavaSourceFileObject(name2, ZipUtil.getStream(zipFile, zipEntry)));
            }
        });
        return collection;
    }
}

