/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compiler;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class JavaSourceFileObject
extends SimpleJavaFileObject {
    private InputStream inputStream;

    protected JavaSourceFileObject(URI uri) {
        super(uri, JavaFileObject.Kind.SOURCE);
    }

    protected JavaSourceFileObject(String className, String code, Charset charset) {
        this(className, IoUtil.toStream(code, charset));
    }

    protected JavaSourceFileObject(String name2, InputStream inputStream) {
        this(URLUtil.getStringURI(name2.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension));
        this.inputStream = inputStream;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.toUri().toURL().openStream();
        }
        return new BufferedInputStream(this.inputStream);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        try (InputStream in = this.openInputStream();){
            String string2 = IoUtil.readUtf8(in);
            return string2;
        }
    }
}

