/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.XmlUtil;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 1L;

    @Override
    protected String convertInternal(Object value) {
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return XmlUtil.toStr((Node)value);
        }
        if (value instanceof Clob) {
            return StringConverter.clobToStr((Clob)value);
        }
        if (value instanceof Blob) {
            return StringConverter.blobToStr((Blob)value);
        }
        return this.convertToStr(value);
    }

    private static String clobToStr(Clob clob) {
        Reader reader2 = null;
        try {
            reader2 = clob.getCharacterStream();
            String string2 = IoUtil.read(reader2);
            return string2;
        }
        catch (SQLException e2) {
            throw new ConvertException(e2);
        }
        finally {
            IoUtil.close(reader2);
        }
    }

    private static String blobToStr(Blob blob) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string2 = IoUtil.read(in, CharsetUtil.CHARSET_UTF_8);
            return string2;
        }
        catch (SQLException e2) {
            throw new ConvertException(e2);
        }
        finally {
            IoUtil.close(in);
        }
    }
}

