/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.date.TemporalUtil;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.TimeZone;

public class LocalDateTimeUtil {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime of(Instant instant2) {
        return LocalDateTimeUtil.of(instant2, ZoneId.systemDefault());
    }

    public static LocalDateTime ofUTC(Instant instant2) {
        return LocalDateTimeUtil.of(instant2, ZoneId.of("UTC"));
    }

    public static LocalDateTime of(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime of(Instant instant2, ZoneId zoneId) {
        if (null == instant2) {
            return null;
        }
        return LocalDateTime.ofInstant(instant2, ObjectUtil.defaultIfNull(zoneId, ZoneId.systemDefault()));
    }

    public static LocalDateTime of(Instant instant2, TimeZone timeZone) {
        if (null == instant2) {
            return null;
        }
        return LocalDateTimeUtil.of(instant2, ObjectUtil.defaultIfNull(timeZone, TimeZone.getDefault()).toZoneId());
    }

    public static LocalDateTime of(long epochMilli) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime ofUTC(long epochMilli) {
        return LocalDateTimeUtil.ofUTC(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime of(long epochMilli, ZoneId zoneId) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli), zoneId);
    }

    public static LocalDateTime of(long epochMilli, TimeZone timeZone) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(epochMilli), timeZone);
    }

    public static LocalDateTime of(Date date) {
        if (null == date) {
            return null;
        }
        if (date instanceof DateTime) {
            return LocalDateTimeUtil.of(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return LocalDateTimeUtil.of(date.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        return LocalDateTime.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtil.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtil.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parse(CharSequence text) {
        return LocalDateTimeUtil.parse(text, (DateTimeFormatter)null);
    }

    public static LocalDateTime parse(CharSequence text, DateTimeFormatter formatter2) {
        if (null == text) {
            return null;
        }
        if (null == formatter2) {
            return LocalDateTime.parse(text);
        }
        return LocalDateTimeUtil.of(formatter2.parse(text));
    }

    public static LocalDateTime parse(CharSequence text, String format2) {
        if (null == text) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format2)) {
            return LocalDateTimeUtil.of(GlobalCustomFormat.parse(text, format2));
        }
        DateTimeFormatter formatter2 = null;
        if (StrUtil.isNotBlank(format2)) {
            if (StrUtil.startWithIgnoreEquals(format2, "yyyyMMddHHmmss")) {
                String fraction = StrUtil.removePrefix(format2, "yyyyMMddHHmmss");
                if (ReUtil.isMatch("[S]{1,2}", (CharSequence)fraction)) {
                    text = text + StrUtil.repeat('0', 3 - fraction.length());
                }
                formatter2 = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
            } else {
                formatter2 = DateTimeFormatter.ofPattern(format2);
            }
        }
        return LocalDateTimeUtil.parse(text, formatter2);
    }

    public static LocalDate parseDate(CharSequence text) {
        return LocalDateTimeUtil.parseDate(text, (DateTimeFormatter)null);
    }

    public static LocalDate parseDate(CharSequence text, DateTimeFormatter formatter2) {
        if (null == text) {
            return null;
        }
        if (null == formatter2) {
            return LocalDate.parse(text);
        }
        return LocalDateTimeUtil.ofDate(formatter2.parse(text));
    }

    public static LocalDate parseDate(CharSequence text, String format2) {
        if (null == text) {
            return null;
        }
        return LocalDateTimeUtil.parseDate(text, DateTimeFormatter.ofPattern(format2));
    }

    public static String formatNormal(LocalDateTime time2) {
        return LocalDateTimeUtil.format(time2, DatePattern.NORM_DATETIME_FORMATTER);
    }

    public static String format(LocalDateTime time2, DateTimeFormatter formatter2) {
        return TemporalAccessorUtil.format((TemporalAccessor)time2, formatter2);
    }

    public static String format(LocalDateTime time2, String format2) {
        return TemporalAccessorUtil.format((TemporalAccessor)time2, format2);
    }

    public static String formatNormal(LocalDate date) {
        return LocalDateTimeUtil.format(date, DatePattern.NORM_DATE_FORMATTER);
    }

    public static String format(LocalDate date, DateTimeFormatter formatter2) {
        return TemporalAccessorUtil.format((TemporalAccessor)date, formatter2);
    }

    public static String format(LocalDate date, String format2) {
        if (null == date) {
            return null;
        }
        return LocalDateTimeUtil.format(date, DateTimeFormatter.ofPattern(format2));
    }

    public static LocalDateTime offset(LocalDateTime time2, long number, TemporalUnit field) {
        if (null == time2) {
            return null;
        }
        return time2.plus(number, field);
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        return TemporalUtil.between(startTimeInclude, endTimeExclude);
    }

    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        return TemporalUtil.between(startTimeInclude, endTimeExclude, unit);
    }

    public static Period betweenPeriod(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        return Period.between(startTimeInclude, endTimeExclude);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time2) {
        return time2.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time2) {
        return time2.with(LocalTime.MAX);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toEpochMilli(temporalAccessor);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }
}

