/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.BOMInputStream;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileCopier;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.io.file.LineSeparator;
import cn.hutool.core.io.file.PathUtil;
import cn.hutool.core.io.file.Tailer;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class FileUtil
extends PathUtil {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";
    public static final String FILE_SEPARATOR = File.separator;
    public static final String PATH_SEPARATOR = File.pathSeparator;

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static File[] ls(String path2) {
        if (path2 == null) {
            return null;
        }
        File file2 = FileUtil.file(path2);
        if (file2.isDirectory()) {
            return file2.listFiles();
        }
        throw new IORuntimeException(StrUtil.format("Path [{}] is not directory!", path2));
    }

    public static boolean isEmpty(File file2) {
        if (null == file2 || !file2.exists()) {
            return true;
        }
        if (file2.isDirectory()) {
            String[] subFiles = file2.list();
            return ArrayUtil.isEmpty(subFiles);
        }
        if (file2.isFile()) {
            return file2.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file2) {
        return false == FileUtil.isEmpty(file2);
    }

    public static boolean isDirEmpty(File dir2) {
        return FileUtil.isDirEmpty(dir2.toPath());
    }

    public static List<File> loopFiles(String path2, FileFilter fileFilter) {
        return FileUtil.loopFiles(FileUtil.file(path2), fileFilter);
    }

    public static List<File> loopFiles(File file2, FileFilter fileFilter) {
        return FileUtil.loopFiles(file2, -1, fileFilter);
    }

    public static void walkFiles(File file2, Consumer<File> consumer) {
        if (file2.isDirectory()) {
            File[] subFiles = file2.listFiles();
            if (ArrayUtil.isNotEmpty(subFiles)) {
                for (File tmp : subFiles) {
                    FileUtil.walkFiles(tmp, consumer);
                }
            }
        } else {
            consumer.accept(file2);
        }
    }

    public static List<File> loopFiles(File file2, int maxDepth, FileFilter fileFilter) {
        return FileUtil.loopFiles(file2.toPath(), maxDepth, fileFilter);
    }

    public static List<File> loopFiles(String path2) {
        return FileUtil.loopFiles(FileUtil.file(path2));
    }

    public static List<File> loopFiles(File file2) {
        return FileUtil.loopFiles(file2, null);
    }

    public static List<String> listFileNames(String path2) throws IORuntimeException {
        List<String> files2;
        if (path2 == null) {
            return new ArrayList<String>(0);
        }
        int index2 = path2.lastIndexOf(JAR_PATH_EXT);
        if (index2 < 0) {
            File[] files2;
            ArrayList<String> paths = new ArrayList<String>();
            for (File file2 : files2 = FileUtil.ls(path2)) {
                if (!file2.isFile()) continue;
                paths.add(file2.getName());
            }
            return paths;
        }
        path2 = FileUtil.getAbsolutePath(path2);
        index2 += JAR_FILE_EXT.length();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path2.substring(0, index2));
            files2 = ZipUtil.listFileNames(jarFile, StrUtil.removePrefix(path2.substring(index2 + 1), "/"));
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(StrUtil.format("Can not read file path of [{}]", path2), e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(jarFile);
                throw throwable;
            }
        }
        IoUtil.close(jarFile);
        return files2;
    }

    public static File newFile(String path2) {
        return new File(path2);
    }

    public static File file(String path2) {
        if (null == path2) {
            return null;
        }
        return new File(FileUtil.getAbsolutePath(path2));
    }

    public static File file(String parent, String path2) {
        return FileUtil.file(new File(parent), path2);
    }

    public static File file(File parent, String path2) {
        if (StrUtil.isBlank(path2)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileUtil.checkSlip(parent, FileUtil.buildFile(parent, path2));
    }

    public static File file(File directory, String ... names) {
        Assert.notNull(directory, "directory must not be null", new Object[0]);
        if (ArrayUtil.isEmpty(names)) {
            return directory;
        }
        File file2 = directory;
        for (String name2 : names) {
            if (null == name2) continue;
            file2 = FileUtil.file(file2, name2);
        }
        return file2;
    }

    public static File file(String ... names) {
        if (ArrayUtil.isEmpty(names)) {
            return null;
        }
        File file2 = null;
        for (String name2 : names) {
            file2 = file2 == null ? FileUtil.file(name2) : FileUtil.file(file2, name2);
        }
        return file2;
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(URLUtil.toURI(url));
    }

    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return FileUtil.file(FileUtil.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return FileUtil.file(FileUtil.getUserHomePath());
    }

    public static boolean exist(String path2) {
        return null != path2 && FileUtil.file(path2).exists();
    }

    public static boolean exist(File file2) {
        return null != file2 && file2.exists();
    }

    public static boolean exist(String directory, String regexp) {
        File file2 = new File(directory);
        if (!file2.exists()) {
            return false;
        }
        String[] fileList = file2.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file2) {
        if (!FileUtil.exist(file2)) {
            return null;
        }
        return new Date(file2.lastModified());
    }

    public static Date lastModifiedTime(String path2) {
        return FileUtil.lastModifiedTime(new File(path2));
    }

    public static long size(File file2) {
        if (null == file2 || !file2.exists() || FileUtil.isSymlink(file2)) {
            return 0L;
        }
        if (file2.isDirectory()) {
            long size = 0L;
            File[] subFiles = file2.listFiles();
            if (ArrayUtil.isEmpty(subFiles)) {
                return 0L;
            }
            for (File subFile : subFiles) {
                size += FileUtil.size(subFile);
            }
            return size;
        }
        return file2.length();
    }

    public static boolean newerThan(File file2, File reference) {
        if (null == reference || !reference.exists()) {
            return true;
        }
        return FileUtil.newerThan(file2, reference.lastModified());
    }

    public static boolean newerThan(File file2, long timeMillis) {
        if (null == file2 || !file2.exists()) {
            return false;
        }
        return file2.lastModified() > timeMillis;
    }

    public static File touch(String fullFilePath) throws IORuntimeException {
        if (fullFilePath == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(fullFilePath));
    }

    public static File touch(File file2) throws IORuntimeException {
        if (null == file2) {
            return null;
        }
        if (!file2.exists()) {
            FileUtil.mkParentDirs(file2);
            try {
                file2.createNewFile();
            }
            catch (Exception e2) {
                throw new IORuntimeException(e2);
            }
        }
        return file2;
    }

    public static File touch(File parent, String path2) throws IORuntimeException {
        return FileUtil.touch(FileUtil.file(parent, path2));
    }

    public static File touch(String parent, String path2) throws IORuntimeException {
        return FileUtil.touch(FileUtil.file(parent, path2));
    }

    public static File mkParentDirs(File file2) {
        if (null == file2) {
            return null;
        }
        return FileUtil.mkdir(file2.getParentFile());
    }

    public static File mkParentDirs(String path2) {
        if (path2 == null) {
            return null;
        }
        return FileUtil.mkParentDirs(FileUtil.file(path2));
    }

    public static boolean del(String fullFileOrDirPath) throws IORuntimeException {
        return FileUtil.del(FileUtil.file(fullFileOrDirPath));
    }

    public static boolean del(File file2) throws IORuntimeException {
        boolean isOk;
        if (file2 == null || !file2.exists()) {
            return true;
        }
        if (file2.isDirectory() && !(isOk = FileUtil.clean(file2))) {
            return false;
        }
        Path path2 = file2.toPath();
        try {
            FileUtil.delFile(path2);
        }
        catch (DirectoryNotEmptyException e2) {
            FileUtil.del(path2);
        }
        catch (IOException e3) {
            throw new IORuntimeException(e3);
        }
        return true;
    }

    public static boolean clean(String dirPath) throws IORuntimeException {
        return FileUtil.clean(FileUtil.file(dirPath));
    }

    public static boolean clean(File directory) throws IORuntimeException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (null != files) {
            for (File childFile : files) {
                if (FileUtil.del(childFile)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean cleanEmpty(File directory) throws IORuntimeException {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (ArrayUtil.isEmpty(files)) {
            return directory.delete();
        }
        for (File childFile : files) {
            FileUtil.cleanEmpty(childFile);
        }
        return true;
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir2 = FileUtil.file(dirPath);
        return FileUtil.mkdir(dir2);
    }

    public static File mkdir(File dir2) {
        if (dir2 == null) {
            return null;
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        return dir2;
    }

    public static File createTempFile(File dir2) throws IORuntimeException {
        return FileUtil.createTempFile("hutool", null, dir2, true);
    }

    public static File createTempFile(File dir2, boolean isReCreat) throws IORuntimeException {
        return FileUtil.createTempFile("hutool", null, dir2, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir2, boolean isReCreat) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file2 = File.createTempFile(prefix, suffix, FileUtil.mkdir(dir2)).getCanonicalFile();
                if (isReCreat) {
                    file2.delete();
                    file2.createNewFile();
                }
                return file2;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws IORuntimeException {
        Assert.notBlank(src, "Source File path is blank !", new Object[0]);
        Assert.notBlank(dest, "Destination File path is blank !", new Object[0]);
        return FileUtil.copyFile(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), options).toFile();
    }

    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new IORuntimeException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        if (FileUtil.equals(src, dest)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", src, dest);
        }
        return FileUtil.copyFile(src.toPath(), dest.toPath(), options).toFile();
    }

    public static File copy(String srcPath, String destPath, boolean isOverride) throws IORuntimeException {
        return FileUtil.copy(FileUtil.file(srcPath), FileUtil.file(destPath), isOverride);
    }

    public static File copy(File src, File dest, boolean isOverride) throws IORuntimeException {
        return FileCopier.create(src, dest).setOverride(isOverride).copy();
    }

    public static File copyContent(File src, File dest, boolean isOverride) throws IORuntimeException {
        return FileCopier.create(src, dest).setCopyContentIfDir(true).setOverride(isOverride).copy();
    }

    public static File copyFilesFromDir(File src, File dest, boolean isOverride) throws IORuntimeException {
        return FileCopier.create(src, dest).setCopyContentIfDir(true).setOnlyCopyFile(true).setOverride(isOverride).copy();
    }

    public static void move(File src, File target, boolean isOverride) throws IORuntimeException {
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtil.move(src.toPath(), target.toPath(), isOverride);
    }

    public static void moveContent(File src, File target, boolean isOverride) throws IORuntimeException {
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        FileUtil.moveContent(src.toPath(), target.toPath(), isOverride);
    }

    public static File rename(File file2, String newName, boolean isOverride) {
        return FileUtil.rename(file2, newName, false, isOverride);
    }

    public static File rename(File file2, String newName, boolean isRetainExt, boolean isOverride) {
        String extName;
        if (isRetainExt && StrUtil.isNotBlank(extName = FileUtil.extName(file2))) {
            newName = newName.concat(".").concat(extName);
        }
        return FileUtil.rename(file2.toPath(), newName, isOverride).toFile();
    }

    public static String getCanonicalPath(File file2) {
        if (null == file2) {
            return null;
        }
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static String getAbsolutePath(String path2, Class<?> baseClass) {
        String normalPath;
        if (path2 == null) {
            normalPath = "";
        } else {
            normalPath = FileUtil.normalize(path2);
            if (FileUtil.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = ResourceUtil.getResource(normalPath, baseClass);
        if (null != url) {
            return FileUtil.normalize(URLUtil.getDecodedPath(url));
        }
        String classPath = ClassUtil.getClassPath();
        if (null == classPath) {
            return path2;
        }
        return FileUtil.normalize(classPath.concat(Objects.requireNonNull(path2)));
    }

    public static String getAbsolutePath(String path2) {
        return FileUtil.getAbsolutePath(path2, null);
    }

    public static String getAbsolutePath(File file2) {
        if (file2 == null) {
            return null;
        }
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e2) {
            return file2.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path2) {
        if (StrUtil.isEmpty(path2)) {
            return false;
        }
        return '/' == path2.charAt(0) || path2.matches("^[a-zA-Z]:([/\\\\].*)?");
    }

    public static boolean isDirectory(String path2) {
        return null != path2 && FileUtil.file(path2).isDirectory();
    }

    public static boolean isDirectory(File file2) {
        return null != file2 && file2.isDirectory();
    }

    public static boolean isFile(String path2) {
        return null != path2 && FileUtil.file(path2).isFile();
    }

    public static boolean isFile(File file2) {
        return null != file2 && file2.isFile();
    }

    public static boolean equals(File file1, File file2) throws IORuntimeException {
        Assert.notNull(file1);
        Assert.notNull(file2);
        if (!file1.exists() || !file2.exists()) {
            return false == file1.exists() && false == file2.exists() && FileUtil.pathEquals(file1, file2);
        }
        return FileUtil.equals(file1.toPath(), file2.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws IORuntimeException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileUtil.equals(file1, file2)) {
            return true;
        }
        BufferedInputStream input1 = null;
        BufferedInputStream input2 = null;
        try {
            input1 = FileUtil.getInputStream(file1);
            input2 = FileUtil.getInputStream(file2);
            boolean bl = IoUtil.contentEquals(input1, input2);
            return bl;
        }
        finally {
            IoUtil.close(input1);
            IoUtil.close(input2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEqualsIgnoreEOL(File file1, File file2, Charset charset) throws IORuntimeException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files");
        }
        if (FileUtil.equals(file1, file2)) {
            return true;
        }
        BufferedReader input1 = null;
        BufferedReader input2 = null;
        try {
            input1 = FileUtil.getReader(file1, charset);
            input2 = FileUtil.getReader(file2, charset);
            bl = IoUtil.contentEqualsIgnoreEOL(input1, input2);
        }
        catch (Throwable throwable) {
            IoUtil.close(input1);
            IoUtil.close(input2);
            throw throwable;
        }
        IoUtil.close(input1);
        IoUtil.close(input2);
        return bl;
    }

    public static boolean pathEquals(File file1, File file2) {
        block8: {
            if (FileUtil.isWindows()) {
                try {
                    if (StrUtil.equalsIgnoreCase(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e2) {
                    if (StrUtil.equalsIgnoreCase(file1.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StrUtil.equals(file1.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e3) {
                if (!StrUtil.equals(file1.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (StrUtil.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                char c = filePath.charAt(i);
                if (!CharUtil.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    @Deprecated
    public static boolean isModifed(File file2, long lastModifyTime) {
        return FileUtil.isModified(file2, lastModifyTime);
    }

    public static boolean isModified(File file2, long lastModifyTime) {
        if (null == file2 || !file2.exists()) {
            return true;
        }
        return file2.lastModified() != lastModifyTime;
    }

    public static String normalize(String path2) {
        if (path2 == null) {
            return null;
        }
        String pathToUse = StrUtil.removePrefixIgnoreCase(path2, "classpath:");
        if (StrUtil.startWith((CharSequence)(pathToUse = StrUtil.removePrefixIgnoreCase(pathToUse, PATH_FILE_PRE)), '~')) {
            pathToUse = FileUtil.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = StrUtil.trimStart(pathToUse);
        if (path2.startsWith("\\\\")) {
            pathToUse = "\\" + pathToUse;
        }
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (StrUtil.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StrUtil.split((CharSequence)pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && StrUtil.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + CollUtil.join(pathElements, (CharSequence)"/");
    }

    public static String subPath(String rootDir, File file2) {
        try {
            return FileUtil.subPath(rootDir, file2.getCanonicalPath());
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static String subPath(String dirPath, String filePath) {
        if (StrUtil.isNotEmpty(dirPath) && StrUtil.isNotEmpty(filePath)) {
            dirPath = StrUtil.removeSuffix(FileUtil.normalize(dirPath), "/");
            filePath = FileUtil.normalize(filePath);
            String result = StrUtil.removePrefixIgnoreCase(filePath, dirPath);
            return StrUtil.removePrefix(result, "/");
        }
        return filePath;
    }

    public static String getName(File file2) {
        return FileNameUtil.getName(file2);
    }

    public static String getName(String filePath) {
        return FileNameUtil.getName(filePath);
    }

    public static String getSuffix(File file2) {
        return FileNameUtil.getSuffix(file2);
    }

    public static String getSuffix(String fileName) {
        return FileNameUtil.getSuffix(fileName);
    }

    public static String getPrefix(File file2) {
        return FileNameUtil.getPrefix(file2);
    }

    public static String getPrefix(String fileName) {
        return FileNameUtil.getPrefix(fileName);
    }

    public static String mainName(File file2) {
        return FileNameUtil.mainName(file2);
    }

    public static String mainName(String fileName) {
        return FileNameUtil.mainName(fileName);
    }

    public static String extName(File file2) {
        return FileNameUtil.extName(file2);
    }

    public static String extName(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    public static boolean pathEndsWith(File file2, String suffix) {
        return file2.getPath().toLowerCase().endsWith(suffix);
    }

    public static String getType(File file2) throws IORuntimeException {
        return FileTypeUtil.getType(file2);
    }

    public static BufferedInputStream getInputStream(File file2) throws IORuntimeException {
        return IoUtil.toBuffered(IoUtil.toStream(file2));
    }

    public static BufferedInputStream getInputStream(String path2) throws IORuntimeException {
        return FileUtil.getInputStream(FileUtil.file(path2));
    }

    public static BOMInputStream getBOMInputStream(File file2) throws IORuntimeException {
        try {
            return new BOMInputStream(new FileInputStream(file2));
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static BufferedReader getBOMReader(File file2) {
        return IoUtil.getReader(FileUtil.getBOMInputStream(file2));
    }

    public static BufferedReader getUtf8Reader(File file2) throws IORuntimeException {
        return FileUtil.getReader(file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path2) throws IORuntimeException {
        return FileUtil.getReader(path2, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public static BufferedReader getReader(File file2, String charsetName) throws IORuntimeException {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file2), CharsetUtil.charset(charsetName));
    }

    public static BufferedReader getReader(File file2, Charset charset) throws IORuntimeException {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file2), charset);
    }

    @Deprecated
    public static BufferedReader getReader(String path2, String charsetName) throws IORuntimeException {
        return FileUtil.getReader(path2, CharsetUtil.charset(charsetName));
    }

    public static BufferedReader getReader(String path2, Charset charset) throws IORuntimeException {
        return FileUtil.getReader(FileUtil.file(path2), charset);
    }

    public static byte[] readBytes(File file2) throws IORuntimeException {
        return FileReader.create(file2).readBytes();
    }

    public static byte[] readBytes(String filePath) throws IORuntimeException {
        return FileUtil.readBytes(FileUtil.file(filePath));
    }

    public static String readUtf8String(File file2) throws IORuntimeException {
        return FileUtil.readString(file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readUtf8String(String path2) throws IORuntimeException {
        return FileUtil.readString(path2, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public static String readString(File file2, String charsetName) throws IORuntimeException {
        return FileUtil.readString(file2, CharsetUtil.charset(charsetName));
    }

    public static String readString(File file2, Charset charset) throws IORuntimeException {
        return FileReader.create(file2, charset).readString();
    }

    @Deprecated
    public static String readString(String path2, String charsetName) throws IORuntimeException {
        return FileUtil.readString(path2, CharsetUtil.charset(charsetName));
    }

    public static String readString(String path2, Charset charset) throws IORuntimeException {
        return FileUtil.readString(FileUtil.file(path2), charset);
    }

    @Deprecated
    public static String readString(URL url, String charsetName) throws IORuntimeException {
        return FileUtil.readString(url, CharsetUtil.charset(charsetName));
    }

    public static String readString(URL url, Charset charset) throws IORuntimeException {
        if (url == null) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string2 = IoUtil.read(in, charset);
            return string2;
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static <T extends Collection<String>> T readUtf8Lines(String path2, T collection) throws IORuntimeException {
        return FileUtil.readLines(path2, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(String path2, String charset, T collection) throws IORuntimeException {
        return FileUtil.readLines(FileUtil.file(path2), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(String path2, Charset charset, T collection) throws IORuntimeException {
        return FileUtil.readLines(FileUtil.file(path2), charset, collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(File file2, T collection) throws IORuntimeException {
        return FileUtil.readLines(file2, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(File file2, String charset, T collection) throws IORuntimeException {
        return FileReader.create(file2, CharsetUtil.charset(charset)).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(File file2, Charset charset, T collection) throws IORuntimeException {
        return FileReader.create(file2, charset).readLines(collection);
    }

    public static <T extends Collection<String>> T readUtf8Lines(URL url, T collection) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.CHARSET_UTF_8, collection);
    }

    @Deprecated
    public static <T extends Collection<String>> T readLines(URL url, String charsetName, T collection) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, Charset charset, T collection) throws IORuntimeException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoUtil.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static List<String> readUtf8Lines(URL url) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public static List<String> readLines(URL url, String charsetName) throws IORuntimeException {
        return FileUtil.readLines(url, CharsetUtil.charset(charsetName));
    }

    public static List<String> readLines(URL url, Charset charset) throws IORuntimeException {
        return FileUtil.readLines(url, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(String path2) throws IORuntimeException {
        return FileUtil.readLines(path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static List<String> readLines(String path2, String charset) throws IORuntimeException {
        return FileUtil.readLines(path2, charset, new ArrayList());
    }

    public static List<String> readLines(String path2, Charset charset) throws IORuntimeException {
        return FileUtil.readLines(path2, charset, new ArrayList());
    }

    public static List<String> readUtf8Lines(File file2) throws IORuntimeException {
        return FileUtil.readLines(file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static List<String> readLines(File file2, String charset) throws IORuntimeException {
        return FileUtil.readLines(file2, charset, new ArrayList());
    }

    public static List<String> readLines(File file2, Charset charset) throws IORuntimeException {
        return FileUtil.readLines(file2, charset, new ArrayList());
    }

    public static void readUtf8Lines(File file2, LineHandler lineHandler) throws IORuntimeException {
        FileUtil.readLines(file2, CharsetUtil.CHARSET_UTF_8, lineHandler);
    }

    public static void readLines(File file2, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        FileReader.create(file2, charset).readLines(lineHandler);
    }

    public static void readLines(RandomAccessFile file2, Charset charset, LineHandler lineHandler) {
        try {
            String line;
            while ((line = file2.readLine()) != null) {
                lineHandler.handle(CharsetUtil.convert(line, CharsetUtil.CHARSET_ISO_8859_1, charset));
            }
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static void readLine(RandomAccessFile file2, Charset charset, LineHandler lineHandler) {
        String line = FileUtil.readLine(file2, charset);
        if (null != line) {
            lineHandler.handle(line);
        }
    }

    public static String readLine(RandomAccessFile file2, Charset charset) {
        String line;
        try {
            line = file2.readLine();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        if (null != line) {
            return CharsetUtil.convert(line, CharsetUtil.CHARSET_ISO_8859_1, charset);
        }
        return null;
    }

    public static <T> T loadUtf8(String path2, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileUtil.load(path2, CharsetUtil.CHARSET_UTF_8, readerHandler);
    }

    public static <T> T load(String path2, String charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileReader.create(FileUtil.file(path2), CharsetUtil.charset(charset)).read(readerHandler);
    }

    public static <T> T load(String path2, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileReader.create(FileUtil.file(path2), charset).read(readerHandler);
    }

    public static <T> T loadUtf8(File file2, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileUtil.load(file2, CharsetUtil.CHARSET_UTF_8, readerHandler);
    }

    public static <T> T load(File file2, Charset charset, FileReader.ReaderHandler<T> readerHandler) throws IORuntimeException {
        return FileReader.create(file2, charset).read(readerHandler);
    }

    public static BufferedOutputStream getOutputStream(File file2) throws IORuntimeException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(FileUtil.touch(file2));
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return IoUtil.toBuffered(out);
    }

    public static BufferedOutputStream getOutputStream(String path2) throws IORuntimeException {
        return FileUtil.getOutputStream(FileUtil.touch(path2));
    }

    @Deprecated
    public static BufferedWriter getWriter(String path2, String charsetName, boolean isAppend) throws IORuntimeException {
        return FileUtil.getWriter(path2, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path2, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileUtil.getWriter(FileUtil.touch(path2), charset, isAppend);
    }

    @Deprecated
    public static BufferedWriter getWriter(File file2, String charsetName, boolean isAppend) throws IORuntimeException {
        return FileUtil.getWriter(file2, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file2, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file2, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(String path2, String charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtil.getWriter(path2, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(String path2, Charset charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtil.getWriter(path2, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file2, String charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtil.getWriter(file2, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file2, Charset charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(FileUtil.getWriter(file2, charset, isAppend));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeUtf8String(String content, String path2) throws IORuntimeException {
        return FileUtil.writeString(content, path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static File writeUtf8String(String content, File file2) throws IORuntimeException {
        return FileUtil.writeString(content, file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static File writeString(String content, String path2, String charset) throws IORuntimeException {
        return FileUtil.writeString(content, FileUtil.touch(path2), charset);
    }

    public static File writeString(String content, String path2, Charset charset) throws IORuntimeException {
        return FileUtil.writeString(content, FileUtil.touch(path2), charset);
    }

    public static File writeString(String content, File file2, String charset) throws IORuntimeException {
        return FileWriter.create(file2, CharsetUtil.charset(charset)).write(content);
    }

    public static File writeString(String content, File file2, Charset charset) throws IORuntimeException {
        return FileWriter.create(file2, charset).write(content);
    }

    public static File appendUtf8String(String content, String path2) throws IORuntimeException {
        return FileUtil.appendString(content, path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static File appendString(String content, String path2, String charset) throws IORuntimeException {
        return FileUtil.appendString(content, FileUtil.touch(path2), charset);
    }

    public static File appendString(String content, String path2, Charset charset) throws IORuntimeException {
        return FileUtil.appendString(content, FileUtil.touch(path2), charset);
    }

    public static File appendUtf8String(String content, File file2) throws IORuntimeException {
        return FileUtil.appendString(content, file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static File appendString(String content, File file2, String charset) throws IORuntimeException {
        return FileWriter.create(file2, CharsetUtil.charset(charset)).append(content);
    }

    public static File appendString(String content, File file2, Charset charset) throws IORuntimeException {
        return FileWriter.create(file2, charset).append(content);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, String path2) throws IORuntimeException {
        return FileUtil.writeLines(list, path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static <T> File writeUtf8Lines(Collection<T> list, File file2) throws IORuntimeException {
        return FileUtil.writeLines(list, file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, String path2, String charset) throws IORuntimeException {
        return FileUtil.writeLines(list, path2, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, String path2, Charset charset) throws IORuntimeException {
        return FileUtil.writeLines(list, path2, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file2, String charset) throws IORuntimeException {
        return FileUtil.writeLines(list, file2, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file2, Charset charset) throws IORuntimeException {
        return FileUtil.writeLines(list, file2, charset, false);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, File file2) throws IORuntimeException {
        return FileUtil.appendLines(list, file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static <T> File appendUtf8Lines(Collection<T> list, String path2) throws IORuntimeException {
        return FileUtil.appendLines(list, path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static <T> File appendLines(Collection<T> list, String path2, String charset) throws IORuntimeException {
        return FileUtil.writeLines(list, path2, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file2, String charset) throws IORuntimeException {
        return FileUtil.writeLines(list, file2, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, String path2, Charset charset) throws IORuntimeException {
        return FileUtil.writeLines(list, path2, charset, true);
    }

    public static <T> File appendLines(Collection<T> list, File file2, Charset charset) throws IORuntimeException {
        return FileUtil.writeLines(list, file2, charset, true);
    }

    public static <T> File writeLines(Collection<T> list, String path2, String charset, boolean isAppend) throws IORuntimeException {
        return FileUtil.writeLines(list, FileUtil.file(path2), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, String path2, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileUtil.writeLines(list, FileUtil.file(path2), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file2, String charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file2, CharsetUtil.charset(charset)).writeLines(list, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file2, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file2, charset).writeLines(list, isAppend);
    }

    public static File writeUtf8Map(Map<?, ?> map2, File file2, String kvSeparator, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file2, CharsetUtil.CHARSET_UTF_8).writeMap(map2, kvSeparator, isAppend);
    }

    public static File writeMap(Map<?, ?> map2, File file2, Charset charset, String kvSeparator, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file2, charset).writeMap(map2, kvSeparator, isAppend);
    }

    public static File writeBytes(byte[] data2, String path2) throws IORuntimeException {
        return FileUtil.writeBytes(data2, FileUtil.touch(path2));
    }

    public static File writeBytes(byte[] data2, File dest) throws IORuntimeException {
        return FileUtil.writeBytes(data2, dest, 0, data2.length, false);
    }

    public static File writeBytes(byte[] data2, File dest, int off, int len, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(dest).write(data2, off, len, isAppend);
    }

    public static File writeFromStream(InputStream in, File dest) throws IORuntimeException {
        return FileUtil.writeFromStream(in, dest, true);
    }

    public static File writeFromStream(InputStream in, File dest, boolean isCloseIn) throws IORuntimeException {
        return FileWriter.create(dest).writeFromStream(in, isCloseIn);
    }

    public static File writeFromStream(InputStream in, String fullFilePath) throws IORuntimeException {
        return FileUtil.writeFromStream(in, FileUtil.touch(fullFilePath));
    }

    public static long writeToStream(File file2, OutputStream out) throws IORuntimeException {
        return FileReader.create(file2).writeToStream(out);
    }

    public static long writeToStream(String fullFilePath, OutputStream out) throws IORuntimeException {
        return FileUtil.writeToStream(FileUtil.touch(fullFilePath), out);
    }

    public static String readableFileSize(File file2) {
        return FileUtil.readableFileSize(file2.length());
    }

    public static String readableFileSize(long size) {
        return DataSizeUtil.format(size);
    }

    public static File convertCharset(File file2, Charset srcCharset, Charset destCharset) {
        return CharsetUtil.convert(file2, srcCharset, destCharset);
    }

    public static File convertLineSeparator(File file2, Charset charset, LineSeparator lineSeparator) {
        List<String> lines = FileUtil.readLines(file2, charset);
        return FileWriter.create(file2, charset).writeLines(lines, lineSeparator, false);
    }

    public static String cleanInvalid(String fileName) {
        return FileNameUtil.cleanInvalid(fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return FileNameUtil.containsInvalid(fileName);
    }

    public static long checksumCRC32(File file2) throws IORuntimeException {
        return FileUtil.checksum(file2, new CRC32()).getValue();
    }

    public static Checksum checksum(File file2, Checksum checksum) throws IORuntimeException {
        Assert.notNull(file2, "File is null !", new Object[0]);
        if (file2.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return IoUtil.checksum(new FileInputStream(file2), checksum);
        }
        catch (FileNotFoundException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static File getWebRoot() {
        String classPath = ClassUtil.getClassPath();
        if (StrUtil.isNotBlank(classPath)) {
            return FileUtil.getParent(FileUtil.file(classPath), 2);
        }
        return null;
    }

    public static String getParent(String filePath, int level) {
        File parent = FileUtil.getParent(FileUtil.file(filePath), level);
        try {
            return null == parent ? null : parent.getCanonicalPath();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static File getParent(File file2, int level) {
        File parentFile;
        if (level < 1 || null == file2) {
            return file2;
        }
        try {
            parentFile = file2.getCanonicalFile().getParentFile();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileUtil.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file2) throws IllegalArgumentException {
        if (null != parentFile && null != file2) {
            String canonicalPath;
            String parentCanonicalPath;
            try {
                parentCanonicalPath = parentFile.getCanonicalPath();
                canonicalPath = file2.getCanonicalPath();
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
            if (!canonicalPath.startsWith(parentCanonicalPath)) {
                throw new IllegalArgumentException("New file is outside of the parent dir: " + file2.getName());
            }
        }
        return file2;
    }

    public static String getMimeType(String filePath) {
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filePath);
        if (null == contentType) {
            if (filePath.endsWith(".css")) {
                contentType = "text/css";
            } else if (filePath.endsWith(".js")) {
                contentType = "application/x-javascript";
            }
        }
        if (null == contentType) {
            contentType = FileUtil.getMimeType(Paths.get(filePath, new String[0]));
        }
        return contentType;
    }

    public static boolean isSymlink(File file2) {
        return FileUtil.isSymlink(file2.toPath());
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return FileUtil.isSub(parent.toPath(), sub.toPath());
    }

    public static RandomAccessFile createRandomAccessFile(Path path2, FileMode mode) {
        return FileUtil.createRandomAccessFile(path2.toFile(), mode);
    }

    public static RandomAccessFile createRandomAccessFile(File file2, FileMode mode) {
        try {
            return new RandomAccessFile(file2, mode.name());
        }
        catch (FileNotFoundException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static void tail(File file2, LineHandler handler) {
        FileUtil.tail(file2, CharsetUtil.CHARSET_UTF_8, handler);
    }

    public static void tail(File file2, Charset charset, LineHandler handler) {
        new Tailer(file2, charset, handler).start();
    }

    public static void tail(File file2, Charset charset) {
        FileUtil.tail(file2, charset, Tailer.CONSOLE_HANDLER);
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!FileUtil.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = StrUtil.split((CharSequence)fileName, '/', false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }
}

