/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.util.regex.Pattern;

public class FileNameUtil {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_JAR = ".jar";
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|]");

    public static String getName(File file2) {
        return null != file2 ? file2.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (CharUtil.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!CharUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String getSuffix(File file2) {
        return FileNameUtil.extName(file2);
    }

    public static String getSuffix(String fileName) {
        return FileNameUtil.extName(fileName);
    }

    public static String getPrefix(File file2) {
        return FileNameUtil.mainName(file2);
    }

    public static String getPrefix(String fileName) {
        return FileNameUtil.mainName(fileName);
    }

    public static String mainName(File file2) {
        if (file2.isDirectory()) {
            return file2.getName();
        }
        return FileNameUtil.mainName(file2.getName());
    }

    public static String mainName(String fileName) {
        if (null == fileName) {
            return null;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        if (CharUtil.isFileSeparator(fileName.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        int end = len;
        for (int i = len - 1; i >= 0; --i) {
            char c = fileName.charAt(i);
            if (len == end && '.' == c) {
                end = i;
            }
            if (!CharUtil.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return fileName.substring(begin, end);
    }

    public static String extName(File file2) {
        if (null == file2) {
            return null;
        }
        if (file2.isDirectory()) {
            return null;
        }
        return FileNameUtil.extName(file2.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index2 = fileName.lastIndexOf(".");
        if (index2 == -1) {
            return "";
        }
        String ext = fileName.substring(index2 + 1);
        return StrUtil.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String cleanInvalid(String fileName) {
        return StrUtil.isBlank(fileName) ? fileName : ReUtil.delAll(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static boolean containsInvalid(String fileName) {
        return false == StrUtil.isBlank(fileName) && ReUtil.contains(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)fileName);
    }

    public static boolean isType(String fileName, String ... extNames) {
        return StrUtil.equalsAnyIgnoreCase(FileNameUtil.extName(fileName), extNames);
    }
}

