/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileWrapper;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileReader create(File file2, Charset charset) {
        return new FileReader(file2, charset);
    }

    public static FileReader create(File file2) {
        return new FileReader(file2);
    }

    public FileReader(File file2, Charset charset) {
        super(file2, charset);
        this.checkFile();
    }

    public FileReader(File file2, String charset) {
        this(file2, CharsetUtil.charset(charset));
    }

    public FileReader(String filePath, Charset charset) {
        this(FileUtil.file(filePath), charset);
    }

    public FileReader(String filePath, String charset) {
        this(FileUtil.file(filePath), CharsetUtil.charset(charset));
    }

    public FileReader(File file2) {
        this(file2, DEFAULT_CHARSET);
    }

    public FileReader(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public byte[] readBytes() throws IORuntimeException {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IORuntimeException("File is larger then max array size");
        }
        byte[] bytes2 = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes2);
            if ((long)readLength < len) {
                throw new IOException(StrUtil.format("File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return bytes2;
    }

    public String readString() throws IORuntimeException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws IORuntimeException {
        T t;
        BufferedReader reader2 = null;
        try {
            String line;
            reader2 = FileUtil.getReader(this.file, this.charset);
            while ((line = reader2.readLine()) != null) {
                collection.add((String)line);
            }
            t = collection;
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(reader2);
                throw throwable;
            }
        }
        IoUtil.close(reader2);
        return t;
    }

    public void readLines(LineHandler lineHandler) throws IORuntimeException {
        BufferedReader reader2 = null;
        try {
            reader2 = FileUtil.getReader(this.file, this.charset);
            IoUtil.readLines((Reader)reader2, lineHandler);
        }
        catch (Throwable throwable) {
            IoUtil.close(reader2);
            throw throwable;
        }
        IoUtil.close(reader2);
    }

    public List<String> readLines() throws IORuntimeException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(ReaderHandler<T> readerHandler) throws IORuntimeException {
        T result;
        BufferedReader reader2 = null;
        try {
            reader2 = FileUtil.getReader(this.file, this.charset);
            result = readerHandler.handle(reader2);
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(reader2);
                throw throwable;
            }
        }
        IoUtil.close(reader2);
        return result;
    }

    public BufferedReader getReader() throws IORuntimeException {
        return IoUtil.getReader((InputStream)this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws IORuntimeException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public long writeToStream(OutputStream out) throws IORuntimeException {
        return this.writeToStream(out, false);
    }

    /*
     * Exception decompiling
     */
    public long writeToStream(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkFile() throws IORuntimeException {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

