/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    public static JarClassLoader load(File dir2) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(dir2);
        loader.addURL(dir2);
        return loader;
    }

    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(jarFile);
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws UtilException {
        try {
            Method method = ClassUtil.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectUtil.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e2) {
            throw new UtilException(e2);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassUtil.getClassLoader());
    }

    public JarClassLoader addJar(File jarFileOrDir) {
        if (JarClassLoader.isJarFile(jarFileOrDir)) {
            return this.addURL(jarFileOrDir);
        }
        List<File> jars = JarClassLoader.loopJar(jarFileOrDir);
        for (File jar : jars) {
            this.addURL(jar);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarClassLoader addURL(File dir2) {
        super.addURL(URLUtil.getURL(dir2));
        return this;
    }

    private static List<File> loopJar(File file2) {
        return FileUtil.loopFiles(file2, JarClassLoader::isJarFile);
    }

    private static boolean isJarFile(File file2) {
        if (!FileUtil.isFile(file2)) {
            return false;
        }
        return file2.getPath().toLowerCase().endsWith(".jar");
    }
}

