/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.map.CustomKeyMap;
import cn.hutool.core.util.StrUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class CamelCaseLinkedMap<K, V>
extends CustomKeyMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CamelCaseLinkedMap() {
        this(16);
    }

    public CamelCaseLinkedMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseLinkedMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseLinkedMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseLinkedMap(int initialCapacity, float loadFactor) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
    }

    @Override
    protected Object customKey(Object key2) {
        if (key2 instanceof CharSequence) {
            key2 = StrUtil.toCamelCase(key2.toString());
        }
        return key2;
    }
}

