/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Stack;

public class Calculator {
    private final Stack<String> postfixStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String expression) {
        Calculator cal = new Calculator();
        expression = Calculator.transform(expression);
        return cal.calculate(expression);
    }

    private static String transform(String expression) {
        expression = StrUtil.cleanBlank(expression);
        expression = StrUtil.removeSuffix(expression, "=");
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' || arr.length > 1 && arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    public double calculate(String expression) {
        Stack<String> resultStack = new Stack<String>();
        this.prepare(expression);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentValue = this.postfixStack.pop();
            if (!this.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            BigDecimal tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(tempResult.toString());
        }
        return Double.parseDouble((String)resultStack.pop());
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count2 = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isOperator(currentOp)) {
                if (count2 > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count2));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count2 = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count2;
        }
        if (count2 > 1 || count2 == 1 && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count2));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')' || c == '%';
    }

    public boolean compare(char cur, char peek2) {
        int offset = 40;
        if (cur == '%') {
            cur = (char)47;
        }
        if (peek2 == '%') {
            peek2 = (char)47;
        }
        return this.operatPriority[peek2 - 40] >= this.operatPriority[cur - 40];
    }

    private BigDecimal calculate(String firstValue, String secondValue, char currentOp) {
        BigDecimal result;
        switch (currentOp) {
            case '+': {
                result = NumberUtil.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = NumberUtil.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = NumberUtil.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = NumberUtil.div(firstValue, secondValue);
                break;
            }
            case '%': {
                result = NumberUtil.toBigDecimal(firstValue).remainder(NumberUtil.toBigDecimal(secondValue));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + currentOp);
            }
        }
        return result;
    }
}

