/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.VersionComparator;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class CharSequenceUtil {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    public static boolean isBlank(CharSequence str2) {
        int length;
        if (str2 == null || (length = str2.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str2) {
        return false == CharSequenceUtil.isBlank(str2);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str2 : strs) {
            if (!CharSequenceUtil.isBlank(str2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str2 : strs) {
            if (!CharSequenceUtil.isNotBlank(str2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str2) {
        return str2 == null || str2.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str2) {
        return false == CharSequenceUtil.isEmpty(str2);
    }

    public static String emptyIfNull(CharSequence str2) {
        return CharSequenceUtil.nullToEmpty(str2);
    }

    public static String nullToEmpty(CharSequence str2) {
        return CharSequenceUtil.nullToDefault(str2, EMPTY);
    }

    public static String nullToDefault(CharSequence str2, String defaultStr) {
        return str2 == null ? defaultStr : str2.toString();
    }

    public static String emptyToDefault(CharSequence str2, String defaultStr) {
        return CharSequenceUtil.isEmpty(str2) ? defaultStr : str2.toString();
    }

    public static String blankToDefault(CharSequence str2, String defaultStr) {
        return CharSequenceUtil.isBlank(str2) ? defaultStr : str2.toString();
    }

    public static String emptyToNull(CharSequence str2) {
        return CharSequenceUtil.isEmpty(str2) ? null : str2.toString();
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str2 : strs) {
            if (!CharSequenceUtil.isEmpty(str2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str2 : strs) {
            if (!CharSequenceUtil.isNotEmpty(str2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return false == CharSequenceUtil.hasEmpty(args);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return false == CharSequenceUtil.hasBlank(args);
    }

    public static boolean isNullOrUndefined(CharSequence str2) {
        if (null == str2) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(str2);
    }

    public static boolean isEmptyOrUndefined(CharSequence str2) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(str2);
    }

    public static boolean isBlankOrUndefined(CharSequence str2) {
        if (CharSequenceUtil.isBlank(str2)) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(str2);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str2) {
        String strString = str2.toString().trim();
        return NULL.equals(strString) || "undefined".equals(strString);
    }

    public static String trim(CharSequence str2) {
        return null == str2 ? null : CharSequenceUtil.trim(str2, 0);
    }

    public static String trimToEmpty(CharSequence str2) {
        return str2 == null ? EMPTY : CharSequenceUtil.trim(str2);
    }

    public static String trimToNull(CharSequence str2) {
        String trimStr = CharSequenceUtil.trim(str2);
        return EMPTY.equals(trimStr) ? null : trimStr;
    }

    public static String trimStart(CharSequence str2) {
        return CharSequenceUtil.trim(str2, -1);
    }

    public static String trimEnd(CharSequence str2) {
        return CharSequenceUtil.trim(str2, 1);
    }

    public static String trim(CharSequence str2, int mode) {
        return CharSequenceUtil.trim(str2, mode, CharUtil::isBlankChar);
    }

    public static String trim(CharSequence str2, int mode, Predicate<Character> predicate) {
        String result;
        if (str2 == null) {
            result = null;
        } else {
            int start;
            int length = str2.length();
            int end = length;
            if (mode <= 0) {
                for (start = 0; start < end && predicate.test(Character.valueOf(str2.charAt(start))); ++start) {
                }
            }
            if (mode >= 0) {
                while (start < end && predicate.test(Character.valueOf(str2.charAt(end - 1)))) {
                    --end;
                }
            }
            result = start > 0 || end < length ? str2.toString().substring(start, end) : str2.toString();
        }
        return result;
    }

    public static boolean startWith(CharSequence str2, char c) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return false;
        }
        return c == str2.charAt(0);
    }

    public static boolean startWith(CharSequence str2, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceUtil.startWith(str2, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str2, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str2 || null == prefix) {
            if (!ignoreEquals) {
                return false;
            }
            return null == str2 && null == prefix;
        }
        boolean isStartWith = ignoreCase ? str2.toString().toLowerCase().startsWith(prefix.toString().toLowerCase()) : str2.toString().startsWith(prefix.toString());
        if (isStartWith) {
            return false == ignoreEquals || false == CharSequenceUtil.equals(str2, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWith(CharSequence str2, CharSequence prefix) {
        return CharSequenceUtil.startWith(str2, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence str2, CharSequence prefix) {
        return CharSequenceUtil.startWith(str2, prefix, false, true);
    }

    public static boolean startWithIgnoreCase(CharSequence str2, CharSequence prefix) {
        return CharSequenceUtil.startWith(str2, prefix, true);
    }

    public static boolean startWithAny(CharSequence str2, CharSequence ... prefixes) {
        if (CharSequenceUtil.isEmpty(str2) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!CharSequenceUtil.startWith(str2, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str2, char c) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return false;
        }
        return c == str2.charAt(str2.length() - 1);
    }

    public static boolean endWith(CharSequence str2, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str2 || null == suffix) {
            return null == str2 && null == suffix;
        }
        if (isIgnoreCase) {
            return str2.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str2.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str2, CharSequence suffix) {
        return CharSequenceUtil.endWith(str2, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str2, CharSequence suffix) {
        return CharSequenceUtil.endWith(str2, suffix, true);
    }

    public static boolean endWithAny(CharSequence str2, CharSequence ... suffixes) {
        if (CharSequenceUtil.isEmpty(str2) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceUtil.endWith(str2, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence str2, CharSequence ... suffixes) {
        if (CharSequenceUtil.isEmpty(str2) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceUtil.endWith(str2, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence str2, char searchChar) {
        return CharSequenceUtil.indexOf(str2, searchChar) > -1;
    }

    public static boolean contains(CharSequence str2, CharSequence searchStr) {
        if (null == str2 || null == searchStr) {
            return false;
        }
        return str2.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str2, CharSequence ... testStrs) {
        return null != CharSequenceUtil.getContainsStr(str2, testStrs);
    }

    public static boolean containsAny(CharSequence str2, char ... testChars) {
        if (!CharSequenceUtil.isEmpty(str2)) {
            int len = str2.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtil.contains(testChars, str2.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str2, char ... testChars) {
        if (!CharSequenceUtil.isEmpty(str2)) {
            int len = str2.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtil.contains(testChars, str2.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str2) {
        if (null == str2) {
            return false;
        }
        int length = str2.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtil.isBlankChar(str2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str2, CharSequence ... testStrs) {
        if (CharSequenceUtil.isEmpty(str2) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str2.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str2, CharSequence testStr) {
        if (null == str2) {
            return null == testStr;
        }
        return str2.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str2, CharSequence ... testStrs) {
        return null != CharSequenceUtil.getContainsStrIgnoreCase(str2, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str2, CharSequence ... testStrs) {
        if (CharSequenceUtil.isEmpty(str2) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!CharSequenceUtil.containsIgnoreCase(str2, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static int indexOf(CharSequence str2, char searchChar) {
        return CharSequenceUtil.indexOf(str2, searchChar, 0);
    }

    public static int indexOf(CharSequence str2, char searchChar, int start) {
        if (str2 instanceof String) {
            return ((String)str2).indexOf(searchChar, start);
        }
        return CharSequenceUtil.indexOf(str2, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str2, char searchChar, int start, int end) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return -1;
        }
        int len = str2.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str2.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str2, CharSequence searchStr) {
        return CharSequenceUtil.indexOfIgnoreCase(str2, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str2, CharSequence searchStr, int fromIndex) {
        return CharSequenceUtil.indexOf(str2, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str2, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str2.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str2.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!CharSequenceUtil.isSubEquals(str2, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str2, CharSequence searchStr) {
        return CharSequenceUtil.lastIndexOfIgnoreCase(str2, searchStr, str2.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str2, CharSequence searchStr, int fromIndex) {
        return CharSequenceUtil.lastIndexOf(str2, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str2, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str2.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str2.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!CharSequenceUtil.isSubEquals(str2, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(CharSequence str2, CharSequence searchStr, int ordinal) {
        if (str2 == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index2 = -1;
        do {
            if ((index2 = CharSequenceUtil.indexOf(str2, searchStr, index2 + 1, false)) >= 0) continue;
            return index2;
        } while (++found < ordinal);
        return index2;
    }

    public static String removeAll(CharSequence str2, CharSequence strToRemove) {
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(strToRemove)) {
            return CharSequenceUtil.str(str2);
        }
        return str2.toString().replace(strToRemove, EMPTY);
    }

    public static String removeAny(CharSequence str2, CharSequence ... strsToRemove) {
        String result = CharSequenceUtil.str(str2);
        if (CharSequenceUtil.isNotEmpty(str2)) {
            for (CharSequence strToRemove : strsToRemove) {
                result = CharSequenceUtil.removeAll((CharSequence)result, strToRemove);
            }
        }
        return result;
    }

    public static String removeAll(CharSequence str2, char ... chars2) {
        if (null == str2 || ArrayUtil.isEmpty(chars2)) {
            return CharSequenceUtil.str(str2);
        }
        int len = str2.length();
        if (0 == len) {
            return CharSequenceUtil.str(str2);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str2.charAt(i);
            if (ArrayUtil.contains(chars2, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAllLineBreaks(CharSequence str2) {
        return CharSequenceUtil.removeAll(str2, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence str2, int preLength) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() > preLength) {
            char first = Character.toLowerCase(str2.charAt(preLength));
            if (str2.length() > preLength + 1) {
                return first + str2.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str2.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str2, CharSequence prefix) {
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removePrefix(str2, prefix));
    }

    public static String removePrefix(CharSequence str2, CharSequence prefix) {
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.str(str2);
        }
        String str22 = str2.toString();
        if (str22.startsWith(prefix.toString())) {
            return CharSequenceUtil.subSuf(str22, prefix.length());
        }
        return str22;
    }

    public static String removePrefixIgnoreCase(CharSequence str2, CharSequence prefix) {
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.str(str2);
        }
        String str22 = str2.toString();
        if (str22.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return CharSequenceUtil.subSuf(str22, prefix.length());
        }
        return str22;
    }

    public static String removeSuffix(CharSequence str2, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.str(str2);
        }
        String str22 = str2.toString();
        if (str22.endsWith(suffix.toString())) {
            return CharSequenceUtil.subPre(str22, str22.length() - suffix.length());
        }
        return str22;
    }

    public static String removeSufAndLowerFirst(CharSequence str2, CharSequence suffix) {
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removeSuffix(str2, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str2, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.str(str2);
        }
        String str22 = str2.toString();
        if (str22.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return CharSequenceUtil.subPre(str22, str22.length() - suffix.length());
        }
        return str22;
    }

    public static String cleanBlank(CharSequence str2) {
        return CharSequenceUtil.filter(str2, c -> false == CharUtil.isBlankChar(c.charValue()));
    }

    public static String strip(CharSequence str2, CharSequence prefixOrSuffix) {
        if (CharSequenceUtil.equals(str2, prefixOrSuffix)) {
            return EMPTY;
        }
        return CharSequenceUtil.strip(str2, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str2, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        int from = 0;
        int to = str2.length();
        String str22 = str2.toString();
        if (CharSequenceUtil.startWith((CharSequence)str22, prefix)) {
            from = prefix.length();
        }
        if (CharSequenceUtil.endWith((CharSequence)str22, suffix)) {
            to -= suffix.length();
        }
        return str22.substring(Math.min(from, to), Math.max(from, to));
    }

    public static String stripIgnoreCase(CharSequence str2, CharSequence prefixOrSuffix) {
        return CharSequenceUtil.stripIgnoreCase(str2, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str2, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        int from = 0;
        int to = str2.length();
        String str22 = str2.toString();
        if (CharSequenceUtil.startWithIgnoreCase(str22, prefix)) {
            from = prefix.length();
        }
        if (CharSequenceUtil.endWithIgnoreCase(str22, suffix)) {
            to -= suffix.length();
        }
        return str22.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str2, CharSequence prefix) {
        return CharSequenceUtil.prependIfMissing(str2, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence str2, CharSequence suffix) {
        return CharSequenceUtil.appendIfMissing(str2, suffix, suffix);
    }

    public static long[] splitToLong(CharSequence str2, char separator) {
        return Convert.convert(long[].class, CharSequenceUtil.splitTrim(str2, separator));
    }

    public static long[] splitToLong(CharSequence str2, CharSequence separator) {
        return Convert.convert(long[].class, CharSequenceUtil.splitTrim(str2, separator));
    }

    public static int[] splitToInt(CharSequence str2, char separator) {
        return Convert.convert(int[].class, CharSequenceUtil.splitTrim(str2, separator));
    }

    public static int[] splitToInt(CharSequence str2, CharSequence separator) {
        return Convert.convert(int[].class, CharSequenceUtil.splitTrim(str2, separator));
    }

    public static List<String> split(CharSequence str2, char separator) {
        return CharSequenceUtil.split(str2, separator, 0);
    }

    public static String[] splitToArray(CharSequence str2, CharSequence separator) {
        if (str2 == null) {
            return new String[0];
        }
        return StrSplitter.splitToArray(str2.toString(), CharSequenceUtil.str(separator), 0, false, false);
    }

    public static String[] splitToArray(CharSequence str2, char separator) {
        return CharSequenceUtil.splitToArray(str2, separator, 0);
    }

    public static String[] splitToArray(CharSequence str2, char separator, int limit) {
        if (null == str2) {
            return new String[0];
        }
        return StrSplitter.splitToArray(str2.toString(), separator, limit, false, false);
    }

    public static List<String> split(CharSequence str2, char separator, int limit) {
        return CharSequenceUtil.split(str2, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str2, char separator) {
        return CharSequenceUtil.splitTrim(str2, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str2, CharSequence separator) {
        return CharSequenceUtil.splitTrim(str2, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str2, char separator, int limit) {
        return CharSequenceUtil.split(str2, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence str2, CharSequence separator, int limit) {
        return CharSequenceUtil.split(str2, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str2, char separator, boolean isTrim, boolean ignoreEmpty) {
        return CharSequenceUtil.split(str2, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str2, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str2) {
            return new ArrayList<String>(0);
        }
        return StrSplitter.split(str2.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str2, CharSequence separator) {
        return CharSequenceUtil.split(str2, separator, false, false);
    }

    public static List<String> split(CharSequence str2, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return CharSequenceUtil.split(str2, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str2, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str2) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSplitter.split(str2.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    public static String[] split(CharSequence str2, int len) {
        if (null == str2) {
            return new String[0];
        }
        return StrSplitter.splitByLength(str2.toString(), len);
    }

    public static String[] cut(CharSequence str2, int partLength) {
        if (null == str2) {
            return null;
        }
        int len = str2.length();
        if (len < partLength) {
            return new String[]{str2.toString()};
        }
        int part = NumberUtil.count(len, partLength);
        String[] array2 = new String[part];
        String str22 = str2.toString();
        for (int i = 0; i < part; ++i) {
            array2[i] = str22.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array2;
    }

    public static String sub(CharSequence str2, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        int len = str2.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str2.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subByCodePoint(CharSequence str2, int fromIndex, int toIndex) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        str2.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String subPreGbk(CharSequence str2, int len, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        int counterOfDoubleByte = 0;
        byte[] b = str2.toString().getBytes(CharsetUtil.CHARSET_GBK);
        if (b.length <= len) {
            return str2.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            ++len;
        }
        return new String(b, 0, len, CharsetUtil.CHARSET_GBK) + suffix;
    }

    public static String subPre(CharSequence string2, int toIndexExclude) {
        return CharSequenceUtil.sub(string2, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string2, int fromIndex) {
        if (CharSequenceUtil.isEmpty(string2)) {
            return null;
        }
        return CharSequenceUtil.sub(string2, fromIndex, string2.length());
    }

    public static String subSufByLength(CharSequence string2, int length) {
        if (CharSequenceUtil.isEmpty(string2)) {
            return null;
        }
        if (length <= 0) {
            return EMPTY;
        }
        return CharSequenceUtil.sub(string2, -length, string2.length());
    }

    public static String subWithLength(String input, int fromIndex, int length) {
        return CharSequenceUtil.sub(input, fromIndex, fromIndex + length);
    }

    public static String subBefore(CharSequence string2, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string2) || separator == null) {
            return null == string2 ? null : string2.toString();
        }
        String str2 = string2.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str2.lastIndexOf(sep) : str2.indexOf(sep);
        if (-1 == pos) {
            return str2;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str2.substring(0, pos);
    }

    public static String subBefore(CharSequence string2, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string2)) {
            return null == string2 ? null : EMPTY;
        }
        String str2 = string2.toString();
        int n = pos = isLastSeparator ? str2.lastIndexOf(separator) : str2.indexOf(separator);
        if (-1 == pos) {
            return str2;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str2.substring(0, pos);
    }

    public static String subAfter(CharSequence string2, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string2)) {
            return null == string2 ? null : EMPTY;
        }
        if (separator == null) {
            return EMPTY;
        }
        String str2 = string2.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str2.lastIndexOf(sep) : str2.indexOf(sep);
        if (-1 == pos || string2.length() - 1 == pos) {
            return EMPTY;
        }
        return str2.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string2, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string2)) {
            return null == string2 ? null : EMPTY;
        }
        String str2 = string2.toString();
        int n = pos = isLastSeparator ? str2.lastIndexOf(separator) : str2.indexOf(separator);
        if (-1 == pos) {
            return EMPTY;
        }
        return str2.substring(pos + 1);
    }

    public static String subBetween(CharSequence str2, CharSequence before, CharSequence after) {
        int end;
        if (str2 == null || before == null || after == null) {
            return null;
        }
        String str22 = str2.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str22.indexOf(before2);
        if (start != -1 && (end = str22.indexOf(after2, start + before2.length())) != -1) {
            return str22.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str2, CharSequence beforeAndAfter) {
        return CharSequenceUtil.subBetween(str2, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence str2, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.hasEmpty(str2, prefix, suffix) || !CharSequenceUtil.contains(str2, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split2 = CharSequenceUtil.splitToArray(str2, prefix);
        if (prefix.equals(suffix)) {
            int length = split2.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split2[i]);
            }
        } else {
            for (String fragment : split2) {
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence str2, CharSequence prefixAndSuffix) {
        return CharSequenceUtil.subBetweenAll(str2, prefixAndSuffix, prefixAndSuffix);
    }

    public static String repeat(char c, int count2) {
        if (count2 <= 0) {
            return EMPTY;
        }
        char[] result = new char[count2];
        for (int i = 0; i < count2; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str2, int count2) {
        int n;
        if (null == str2) {
            return null;
        }
        if (count2 <= 0 || str2.length() == 0) {
            return EMPTY;
        }
        if (count2 == 1) {
            return str2.toString();
        }
        int len = str2.length();
        long longSize = (long)len * (long)count2;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array2 = new char[size];
        str2.toString().getChars(0, len, array2, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array2, 0, array2, n, n);
        }
        System.arraycopy(array2, 0, array2, n, size - n);
        return new String(array2);
    }

    public static String repeatByLength(CharSequence str2, int padLen) {
        if (null == str2) {
            return null;
        }
        if (padLen <= 0) {
            return EMPTY;
        }
        int strLen = str2.length();
        if (strLen == padLen) {
            return str2.toString();
        }
        if (strLen > padLen) {
            return CharSequenceUtil.subPre(str2, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str2.charAt(i % strLen);
        }
        return new String(padding);
    }

    public static String repeatAndJoin(CharSequence str2, int count2, CharSequence conjunction) {
        if (count2 <= 0) {
            return EMPTY;
        }
        StrBuilder builder = StrBuilder.create();
        boolean isFirst = true;
        while (count2-- > 0) {
            if (isFirst) {
                isFirst = false;
            } else if (CharSequenceUtil.isNotEmpty(conjunction)) {
                builder.append(conjunction);
            }
            builder.append(str2);
        }
        return builder.toString();
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        return CharSequenceUtil.equalsAny(str1, true, strs);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return CharSequenceUtil.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str2 : strs) {
            if (!CharSequenceUtil.equals(str1, str2, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsCharAt(CharSequence str2, int position, char c) {
        if (null == str2 || position < 0) {
            return false;
        }
        return str2.length() > position && c == str2.charAt(position);
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String format(CharSequence template2, Object ... params) {
        if (null == template2) {
            return NULL;
        }
        if (ArrayUtil.isEmpty(params) || CharSequenceUtil.isBlank(template2)) {
            return template2.toString();
        }
        return StrFormatter.format(template2.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static byte[] utf8Bytes(CharSequence str2) {
        return CharSequenceUtil.bytes(str2, CharsetUtil.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str2) {
        return CharSequenceUtil.bytes(str2, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str2, String charset) {
        return CharSequenceUtil.bytes(str2, CharSequenceUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str2, Charset charset) {
        if (str2 == null) {
            return null;
        }
        if (null == charset) {
            return str2.toString().getBytes();
        }
        return str2.toString().getBytes(charset);
    }

    public static ByteBuffer byteBuffer(CharSequence str2, String charset) {
        return ByteBuffer.wrap(CharSequenceUtil.bytes(str2, charset));
    }

    public static String wrap(CharSequence str2, CharSequence prefixAndSuffix) {
        return CharSequenceUtil.wrap(str2, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str2, CharSequence prefix, CharSequence suffix) {
        return CharSequenceUtil.nullToEmpty(prefix).concat(CharSequenceUtil.nullToEmpty(str2)).concat(CharSequenceUtil.nullToEmpty(suffix));
    }

    public static String[] wrapAllWithPair(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharSequenceUtil.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String wrapIfMissing(CharSequence str2, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (CharSequenceUtil.isNotEmpty(str2)) {
            len += str2.length();
        }
        if (CharSequenceUtil.isNotEmpty(prefix)) {
            len += str2.length();
        }
        if (CharSequenceUtil.isNotEmpty(suffix)) {
            len += str2.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (CharSequenceUtil.isNotEmpty(prefix) && !CharSequenceUtil.startWith(str2, prefix)) {
            sb.append(prefix);
        }
        if (CharSequenceUtil.isNotEmpty(str2)) {
            sb.append(str2);
        }
        if (CharSequenceUtil.isNotEmpty(suffix) && !CharSequenceUtil.endWith(str2, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllWithPairIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharSequenceUtil.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str2, String prefix, String suffix) {
        if (CharSequenceUtil.isWrap(str2, prefix, suffix)) {
            return CharSequenceUtil.sub(str2, prefix.length(), str2.length() - suffix.length());
        }
        return str2.toString();
    }

    public static String unWrap(CharSequence str2, char prefix, char suffix) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        if (str2.charAt(0) == prefix && str2.charAt(str2.length() - 1) == suffix) {
            return CharSequenceUtil.sub(str2, 1, str2.length() - 1);
        }
        return str2.toString();
    }

    public static String unWrap(CharSequence str2, char prefixAndSuffix) {
        return CharSequenceUtil.unWrap(str2, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str2, String prefix, String suffix) {
        if (ArrayUtil.hasNull(str2, prefix, suffix)) {
            return false;
        }
        String str22 = str2.toString();
        return str22.startsWith(prefix) && str22.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str2, String wrapper) {
        return CharSequenceUtil.isWrap(str2, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str2, char wrapper) {
        return CharSequenceUtil.isWrap(str2, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str2, char prefixChar, char suffixChar) {
        if (null == str2) {
            return false;
        }
        return str2.charAt(0) == prefixChar && str2.charAt(str2.length() - 1) == suffixChar;
    }

    public static String padPre(CharSequence str2, int length, CharSequence padStr) {
        if (null == str2) {
            return null;
        }
        int strLen = str2.length();
        if (strLen == length) {
            return str2.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str2, length);
        }
        return CharSequenceUtil.repeatByLength(padStr, length - strLen).concat(str2.toString());
    }

    public static String padPre(CharSequence str2, int length, char padChar) {
        if (null == str2) {
            return null;
        }
        int strLen = str2.length();
        if (strLen == length) {
            return str2.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str2, length);
        }
        return CharSequenceUtil.repeat(padChar, length - strLen).concat(str2.toString());
    }

    public static String padAfter(CharSequence str2, int length, char padChar) {
        if (null == str2) {
            return null;
        }
        int strLen = str2.length();
        if (strLen == length) {
            return str2.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.sub(str2, strLen - length, strLen);
        }
        return str2.toString().concat(CharSequenceUtil.repeat(padChar, length - strLen));
    }

    public static String padAfter(CharSequence str2, int length, CharSequence padStr) {
        if (null == str2) {
            return null;
        }
        int strLen = str2.length();
        if (strLen == length) {
            return str2.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subSufByLength(str2, length);
        }
        return str2.toString().concat(CharSequenceUtil.repeatByLength(padStr, length - strLen));
    }

    public static String center(CharSequence str2, int size) {
        return CharSequenceUtil.center(str2, size, ' ');
    }

    public static String center(CharSequence str2, int size, char padChar) {
        if (str2 == null || size <= 0) {
            return CharSequenceUtil.str(str2);
        }
        int strLen = str2.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str2.toString();
        }
        str2 = CharSequenceUtil.padPre(str2, strLen + pads / 2, padChar);
        str2 = CharSequenceUtil.padAfter(str2, size, padChar);
        return str2.toString();
    }

    public static String center(CharSequence str2, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (str2 == null || size <= 0) {
            return CharSequenceUtil.str(str2);
        }
        if (CharSequenceUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str2.length())) <= 0) {
            return str2.toString();
        }
        str2 = CharSequenceUtil.padPre(str2, strLen + pads / 2, padStr);
        str2 = CharSequenceUtil.padAfter(str2, size, padStr);
        return str2.toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharSequenceUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count2 = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count2;
            idx += strForSearch.length();
        }
        return count2;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count2 = 0;
        if (CharSequenceUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count2;
        }
        return count2;
    }

    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareToIgnoreCase(str2.toString());
    }

    public static int compareVersion(CharSequence version1, CharSequence version2) {
        return VersionComparator.INSTANCE.compare(CharSequenceUtil.str(version1), CharSequenceUtil.str(version2));
    }

    public static String appendIfMissing(CharSequence str2, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceUtil.appendIfMissing(str2, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence str2, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceUtil.appendIfMissing(str2, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence str2, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str2 == null || CharSequenceUtil.isEmpty(suffix) || CharSequenceUtil.endWith(str2, suffix, ignoreCase)) {
            return CharSequenceUtil.str(str2);
        }
        if (ArrayUtil.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharSequenceUtil.endWith(str2, testSuffix, ignoreCase)) continue;
                return str2.toString();
            }
        }
        return str2.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str2, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceUtil.prependIfMissing(str2, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence str2, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceUtil.prependIfMissing(str2, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence str2, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str2 == null || CharSequenceUtil.isEmpty(prefix) || CharSequenceUtil.startWith(str2, prefix, ignoreCase)) {
            return CharSequenceUtil.str(str2);
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!CharSequenceUtil.startWith(str2, s, ignoreCase)) continue;
                return str2.toString();
            }
        }
        return prefix.toString().concat(str2.toString());
    }

    public static String replaceIgnoreCase(CharSequence str2, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceUtil.replace(str2, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence str2, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceUtil.replace(str2, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str2, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return CharSequenceUtil.replace(str2, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str2, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        int index2;
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(searchStr)) {
            return CharSequenceUtil.str(str2);
        }
        if (null == replacement) {
            replacement = EMPTY;
        }
        int strLength = str2.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return CharSequenceUtil.str(str2);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StrBuilder result = StrBuilder.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(str2.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        while ((index2 = CharSequenceUtil.indexOf(str2, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str2.subSequence(preIndex, index2));
            result.append(replacement);
            preIndex = index2 + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str2.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str2, int startInclude, int endExclude, char replacedChar) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        int strLength = str2.length();
        if (startInclude > strLength) {
            return CharSequenceUtil.str(str2);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return CharSequenceUtil.str(str2);
        }
        char[] chars2 = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars2[i] = i >= startInclude && i < endExclude ? replacedChar : str2.charAt(i);
        }
        return new String(chars2);
    }

    public static String replace(CharSequence str2, Pattern pattern, Func1<java.util.regex.Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str2, pattern, replaceFun);
    }

    public static String replace(CharSequence str2, String regex, Func1<java.util.regex.Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str2, regex, replaceFun);
    }

    public static String hide(CharSequence str2, int startInclude, int endExclude) {
        return CharSequenceUtil.replace(str2, startInclude, endExclude, '*');
    }

    public static String desensitized(CharSequence str2, DesensitizedUtil.DesensitizedType desensitizedType) {
        return DesensitizedUtil.desensitized(str2, desensitizedType);
    }

    public static String replaceChars(CharSequence str2, String chars2, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str2) || CharSequenceUtil.isEmpty(chars2)) {
            return CharSequenceUtil.str(str2);
        }
        return CharSequenceUtil.replaceChars(str2, chars2.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str2, char[] chars2, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str2) || ArrayUtil.isEmpty(chars2)) {
            return CharSequenceUtil.str(str2);
        }
        HashSet<Character> set2 = new HashSet<Character>(chars2.length);
        for (char c : chars2) {
            set2.add(Character.valueOf(c));
        }
        int strLen = str2.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str2.charAt(i);
            builder.append(set2.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static int totalLength(CharSequence ... strs) {
        int totalLength = 0;
        for (CharSequence str2 : strs) {
            totalLength += null == str2 ? 0 : str2.length();
        }
        return totalLength;
    }

    public static String maxLength(CharSequence string2, int length) {
        Assert.isTrue(length > 0);
        if (null == string2) {
            return null;
        }
        if (string2.length() <= length) {
            return string2.toString();
        }
        return CharSequenceUtil.sub(string2, 0, length) + "...";
    }

    public <T extends CharSequence> T firstNonNull(T ... strs) {
        return (T)((CharSequence)ArrayUtil.firstNonNull(strs));
    }

    public <T extends CharSequence> T firstNonEmpty(T ... strs) {
        return (T)ArrayUtil.firstMatch(CharSequenceUtil::isNotEmpty, strs);
    }

    public <T extends CharSequence> T firstNonBlank(T ... strs) {
        return (T)ArrayUtil.firstMatch(CharSequenceUtil::isNotBlank, strs);
    }

    public static String upperFirstAndAddPre(CharSequence str2, String preString) {
        if (str2 == null || preString == null) {
            return null;
        }
        return preString + CharSequenceUtil.upperFirst(str2);
    }

    public static String upperFirst(CharSequence str2) {
        char firstChar;
        if (null == str2) {
            return null;
        }
        if (str2.length() > 0 && Character.isLowerCase(firstChar = str2.charAt(0))) {
            return Character.toUpperCase(firstChar) + CharSequenceUtil.subSuf(str2, 1);
        }
        return str2.toString();
    }

    public static String lowerFirst(CharSequence str2) {
        char firstChar;
        if (null == str2) {
            return null;
        }
        if (str2.length() > 0 && Character.isUpperCase(firstChar = str2.charAt(0))) {
            return Character.toLowerCase(firstChar) + CharSequenceUtil.subSuf(str2, 1);
        }
        return str2.toString();
    }

    public static String filter(CharSequence str2, Filter<Character> filter2) {
        if (str2 == null || filter2 == null) {
            return CharSequenceUtil.str(str2);
        }
        int len = str2.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str2.charAt(i);
            if (!filter2.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str2) {
        if (null == str2) {
            return false;
        }
        int len = str2.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str2) {
        if (null == str2) {
            return false;
        }
        int len = str2.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String swapCase(String str2) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return str2;
        }
        char[] buffer = str2.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String toUnderlineCase(CharSequence str2) {
        return NamingCase.toUnderlineCase(str2);
    }

    public static String toSymbolCase(CharSequence str2, char symbol2) {
        return NamingCase.toSymbolCase(str2, symbol2);
    }

    public static String toCamelCase(CharSequence name2) {
        return NamingCase.toCamelCase(name2);
    }

    public static boolean isSurround(CharSequence str2, CharSequence prefix, CharSequence suffix) {
        if (StrUtil.isBlank(str2)) {
            return false;
        }
        if (str2.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str22 = str2.toString();
        return str22.startsWith(prefix.toString()) && str22.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str2, char prefix, char suffix) {
        if (StrUtil.isBlank(str2)) {
            return false;
        }
        if (str2.length() < 2) {
            return false;
        }
        return str2.charAt(0) == prefix && str2.charAt(str2.length() - 1) == suffix;
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str2 : strs) {
            sb.append(str2);
        }
        return sb;
    }

    public static StrBuilder strBuilder(CharSequence ... strs) {
        return StrBuilder.create(strs);
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return CharSequenceUtil.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        if (getOrSetMethodNameStr.startsWith("is")) {
            return CharSequenceUtil.removePreAndLowerFirst(getOrSetMethodName, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return CharSequenceUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return CharSequenceUtil.upperFirstAndAddPre(fieldName, "get");
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        StrBuilder sb = new StrBuilder();
        for (CharSequence str2 : strs) {
            sb.append(isNullToEmpty ? CharSequenceUtil.nullToEmpty(str2) : str2);
        }
        return sb.toString();
    }

    public static String brief(CharSequence str2, int maxLength) {
        if (null == str2) {
            return null;
        }
        int strLength = str2.length();
        if (maxLength <= 0 || strLength <= maxLength) {
            return str2.toString();
        }
        switch (maxLength) {
            case 1: {
                return String.valueOf(str2.charAt(0));
            }
            case 2: {
                return str2.charAt(0) + ".";
            }
            case 3: {
                return str2.charAt(0) + "." + str2.charAt(str2.length() - 1);
            }
        }
        int w = maxLength / 2;
        String str22 = str2.toString();
        return CharSequenceUtil.format("{}...{}", str22.substring(0, maxLength - w), str22.substring(strLength - w + 3));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayUtil.join(objs, conjunction);
    }

    public static <T> String join(CharSequence conjunction, Iterable<T> iterable) {
        return CollUtil.join(iterable, conjunction);
    }

    public static boolean isAllCharMatch(CharSequence value, Matcher<Character> matcher) {
        if (StrUtil.isBlank(value)) {
            return false;
        }
        int i = value.length();
        while (--i >= 0) {
            if (matcher.match(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(CharSequence str2) {
        return CharSequenceUtil.isAllCharMatch(str2, Character::isDigit);
    }

    public static String move(CharSequence str2, int startInclude, int endExclude, int moveLength) {
        if (CharSequenceUtil.isEmpty(str2)) {
            return CharSequenceUtil.str(str2);
        }
        int len = str2.length();
        if (Math.abs(moveLength) > len) {
            moveLength %= len;
        }
        StrBuilder strBuilder = StrBuilder.create(len);
        if (moveLength > 0) {
            int endAfterMove = Math.min(endExclude + moveLength, str2.length());
            strBuilder.append(str2.subSequence(0, startInclude)).append(str2.subSequence(endExclude, endAfterMove)).append(str2.subSequence(startInclude, endExclude)).append(str2.subSequence(endAfterMove, str2.length()));
        } else if (moveLength < 0) {
            int startAfterMove = Math.max(startInclude + moveLength, 0);
            strBuilder.append(str2.subSequence(0, startAfterMove)).append(str2.subSequence(startInclude, endExclude)).append(str2.subSequence(startAfterMove, startInclude)).append(str2.subSequence(endExclude, str2.length()));
        } else {
            return CharSequenceUtil.str(str2);
        }
        return strBuilder.toString();
    }

    public static boolean isCharEquals(String str2) {
        return CharSequenceUtil.isBlank(str2.replace(str2.charAt(0), ' '));
    }
}

