/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PrimitiveArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ArrayUtil
extends PrimitiveArrayUtil {
    public static <T> boolean isEmpty(T[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array2, T[] defaultArray) {
        return ArrayUtil.isEmpty(array2) ? defaultArray : array2;
    }

    public static boolean isEmpty(Object array2) {
        if (array2 != null) {
            if (ArrayUtil.isArray(array2)) {
                return 0 == Array.getLength(array2);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array2) {
        return null != array2 && array2.length != 0;
    }

    public static boolean isNotEmpty(Object array2) {
        return false == ArrayUtil.isEmpty(array2);
    }

    public static <T> boolean hasNull(T ... array2) {
        if (ArrayUtil.isNotEmpty(array2)) {
            for (T element : array2) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isAllNull(T ... array2) {
        return null == ArrayUtil.firstNonNull(array2);
    }

    public static <T> T firstNonNull(T ... array2) {
        return (T)ArrayUtil.firstMatch(Objects::nonNull, array2);
    }

    public static <T> T firstMatch(Matcher<T> matcher, T ... array2) {
        int index2 = ArrayUtil.matchIndex(matcher, array2);
        if (index2 < 0) {
            return null;
        }
        return array2[index2];
    }

    public static <T> int matchIndex(Matcher<T> matcher, T ... array2) {
        return ArrayUtil.matchIndex(matcher, 0, array2);
    }

    public static <T> int matchIndex(Matcher<T> matcher, int beginIndexInclude, T ... array2) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (ArrayUtil.isNotEmpty(array2)) {
            for (int i = beginIndexInclude; i < array2.length; ++i) {
                if (!matcher.match(array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array2) {
        return null == array2 ? null : array2.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type2, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type2) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type2.isArray() ? type2.getComponentType() : type2;
        Object[] array2 = (Object[])arrayObj;
        Object[] result = ArrayUtil.newArray(componentType, array2.length);
        System.arraycopy(array2, 0, result, 0, array2.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtil.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtil.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <T> Object append(Object array2, T ... newElements) {
        if (ArrayUtil.isEmpty(array2)) {
            return newElements;
        }
        return ArrayUtil.insert(array2, ArrayUtil.length(array2), newElements);
    }

    public static <T> T[] setOrAppend(T[] buffer, int index2, T value) {
        if (index2 < buffer.length) {
            Array.set(buffer, index2, value);
            return buffer;
        }
        return ArrayUtil.append(buffer, value);
    }

    public static Object setOrAppend(Object array2, int index2, Object value) {
        if (index2 < ArrayUtil.length(array2)) {
            Array.set(array2, index2, value);
            return array2;
        }
        return ArrayUtil.append(array2, value);
    }

    public static <T> T[] insert(T[] buffer, int index2, T ... newElements) {
        return (Object[])ArrayUtil.insert(buffer, index2, newElements);
    }

    public static <T> Object insert(Object array2, int index2, T ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return array2;
        }
        if (ArrayUtil.isEmpty(array2)) {
            return newElements;
        }
        int len = ArrayUtil.length(array2);
        if (index2 < 0) {
            index2 = index2 % len + len;
        }
        T[] result = ArrayUtil.newArray(array2.getClass().getComponentType(), Math.max(len, index2) + newElements.length);
        System.arraycopy(array2, 0, result, 0, Math.min(len, index2));
        System.arraycopy(newElements, 0, result, index2, newElements.length);
        if (index2 < len) {
            System.arraycopy(array2, index2, result, index2 + newElements.length, len - index2);
        }
        return result;
    }

    public static <T> T[] resize(T[] data2, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data2;
        }
        T[] newArray = ArrayUtil.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(data2)) {
            System.arraycopy(data2, 0, newArray, 0, Math.min(data2.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array2, int newSize) {
        if (newSize < 0) {
            return array2;
        }
        if (null == array2) {
            return null;
        }
        int length = ArrayUtil.length(array2);
        Object newArray = Array.newInstance(array2.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(array2)) {
            System.arraycopy(array2, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtil.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        T[] result = ArrayUtil.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T[] clone(T[] array2) {
        if (array2 == null) {
            return null;
        }
        return (Object[])array2.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] edit(T[] array2, Editor<T> editor) {
        if (null == editor) {
            return array2;
        }
        ArrayList<T> list = new ArrayList<T>(array2.length);
        for (T t : array2) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = ArrayUtil.newArray(array2.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] filter(T[] array2, Filter<T> filter2) {
        if (null == array2 || null == filter2) {
            return array2;
        }
        return ArrayUtil.edit(array2, t -> filter2.accept(t) ? t : null);
    }

    public static <T> T[] removeNull(T[] array2) {
        return ArrayUtil.edit(array2, t -> t);
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array2) {
        return ArrayUtil.filter(array2, CharSequenceUtil::isNotEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array2) {
        return ArrayUtil.filter(array2, CharSequenceUtil::isNotBlank);
    }

    public static String[] nullToEmpty(String[] array2) {
        return ArrayUtil.edit(array2, t -> null == t ? "" : t);
    }

    public static <K, V> Map<K, V> zip(K[] keys2, V[] values, boolean isOrder) {
        if (ArrayUtil.isEmpty(keys2) || ArrayUtil.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys2.length, values.length);
        HashMap<K, V> map2 = MapUtil.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map2.put(keys2[i], values[i]);
        }
        return map2;
    }

    public static <K, V> Map<K, V> zip(K[] keys2, V[] values) {
        return ArrayUtil.zip(keys2, values, false);
    }

    public static <T> int indexOf(T[] array2, Object value, int beginIndexInclude) {
        return ArrayUtil.matchIndex((T obj) -> ObjectUtil.equal(value, obj), beginIndexInclude, array2);
    }

    public static <T> int indexOf(T[] array2, Object value) {
        return ArrayUtil.matchIndex((T obj) -> ObjectUtil.equal(value, obj), array2);
    }

    public static int indexOfIgnoreCase(CharSequence[] array2, CharSequence value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (!StrUtil.equalsIgnoreCase(array2[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array2, Object value) {
        if (ArrayUtil.isEmpty(array2)) {
            return -1;
        }
        return ArrayUtil.lastIndexOf(array2, value, array2.length - 1);
    }

    public static <T> int lastIndexOf(T[] array2, Object value, int endInclude) {
        if (ArrayUtil.isNotEmpty(array2)) {
            for (int i = endInclude; i >= 0; --i) {
                if (!ObjectUtil.equal(value, array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array2, T value) {
        return ArrayUtil.indexOf(array2, value) > -1;
    }

    public static <T> boolean containsAny(T[] array2, T ... values) {
        for (T value : values) {
            if (!ArrayUtil.contains(array2, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array2, T ... values) {
        for (T value : values) {
            if (ArrayUtil.contains(array2, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(CharSequence[] array2, CharSequence value) {
        return ArrayUtil.indexOfIgnoreCase(array2, value) > -1;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e2) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])obj);
                    }
                }
                throw new UtilException(e2);
            }
        }
        throw new UtilException(StrUtil.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static <T> T get(Object array2, int index2) {
        if (null == array2) {
            return null;
        }
        if (index2 < 0) {
            index2 += Array.getLength(array2);
        }
        try {
            return (T)Array.get(array2, index2);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return null;
        }
    }

    public static <T> T[] getAny(Object array2, int ... indexes) {
        if (null == array2) {
            return null;
        }
        T[] result = ArrayUtil.newArray(array2.getClass().getComponentType(), indexes.length);
        for (int i : indexes) {
            result[i] = ArrayUtil.get(array2, i);
        }
        return result;
    }

    public static <T> T[] sub(T[] array2, int start, int end) {
        int length = ArrayUtil.length(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return ArrayUtil.newArray(array2.getClass().getComponentType(), 0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return ArrayUtil.newArray(array2.getClass().getComponentType(), 0);
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static Object[] sub(Object array2, int start, int end) {
        return ArrayUtil.sub(array2, start, end, 1);
    }

    public static Object[] sub(Object array2, int start, int end, int step) {
        int length = ArrayUtil.length(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new Object[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new Object[0];
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        for (int i = start; i < end; i += step) {
            list.add(ArrayUtil.get(array2, i));
        }
        return list.toArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array2) throws IllegalArgumentException {
        if (null == array2) {
            return 0;
        }
        return Array.getLength(array2);
    }

    public static <T> String join(T[] array2, CharSequence conjunction) {
        return ArrayUtil.join(array2, conjunction, null, null);
    }

    public static <T> String join(T[] array2, CharSequence delimiter, String prefix, String suffix) {
        if (null == array2) {
            return null;
        }
        return StrJoiner.of(delimiter, prefix, suffix).setWrapElement(true).append(array2).toString();
    }

    public static <T> String join(T[] array2, CharSequence conjunction, Editor<T> editor) {
        return StrJoiner.of(conjunction).append(array2, t -> String.valueOf(editor.edit(t))).toString();
    }

    public static String join(Object array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        if (!ArrayUtil.isArray(array2)) {
            throw new IllegalArgumentException(StrUtil.format("[{}] is not a Array!", array2.getClass()));
        }
        return StrJoiner.of(conjunction).append(array2).toString();
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (bytebuffer.hasArray()) {
            return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
        }
        int oldPosition = bytebuffer.position();
        bytebuffer.position(0);
        int size = bytebuffer.limit();
        byte[] buffers = new byte[size];
        bytebuffer.get(buffers);
        bytebuffer.position(oldPosition);
        return buffers;
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtil.toArray(CollUtil.newArrayList(iterator), componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtil.toArray(CollectionUtil.toCollection(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        return collection.toArray(ArrayUtil.newArray(componentType, 0));
    }

    public static <T> T[] remove(T[] array2, int index2) throws IllegalArgumentException {
        return (Object[])ArrayUtil.remove(array2, index2);
    }

    public static <T> T[] removeEle(T[] array2, T element) throws IllegalArgumentException {
        return ArrayUtil.remove(array2, ArrayUtil.indexOf(array2, element));
    }

    public static <T> T[] reverse(T[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
        return array2;
    }

    public static <T> T[] reverse(T[] array2) {
        return ArrayUtil.reverse(array2, 0, array2.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator2) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min2 = numberArray[0];
        for (T t : numberArray) {
            if (CompareUtil.compare(min2, t, comparator2) <= 0) continue;
            min2 = t;
        }
        return min2;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator2) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (CompareUtil.compare(max2, numberArray[i], comparator2) >= 0) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static <T> T[] shuffle(T[] array2) {
        return ArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static <T> T[] shuffle(T[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            ArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static <T> T[] swap(T[] array2, int index1, int index2) {
        if (ArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        T tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static Object swap(Object array2, int index1, int index2) {
        if (ArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object tmp = ArrayUtil.get(array2, index1);
        Array.set(array2, index1, Array.get(array2, index2));
        Array.set(array2, index2, tmp);
        return array2;
    }

    public static int emptyCount(Object ... args) {
        int count2 = 0;
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectUtil.isEmpty(element)) continue;
                ++count2;
            }
        }
        return count2;
    }

    public static boolean hasEmpty(Object ... args) {
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectUtil.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... args) {
        return ArrayUtil.emptyCount(args) == args.length;
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return false == ArrayUtil.hasEmpty(args);
    }

    public static <T> boolean isAllNotNull(T ... array2) {
        return false == ArrayUtil.hasNull(array2);
    }

    public static <T> T[] distinct(T[] array2) {
        if (ArrayUtil.isEmpty(array2)) {
            return array2;
        }
        LinkedHashSet set2 = new LinkedHashSet(array2.length, 1.0f);
        Collections.addAll(set2, array2);
        return ArrayUtil.toArray(set2, ArrayUtil.getComponentType(array2));
    }

    public static <T, R> R[] map(T[] array2, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        T[] result = ArrayUtil.newArray(targetComponentType, array2.length);
        for (int i = 0; i < array2.length; ++i) {
            result[i] = func.apply(array2[i]);
        }
        return result;
    }

    public static <T, R> R[] map(Object array2, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        int length = ArrayUtil.length(array2);
        T[] result = ArrayUtil.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(ArrayUtil.get(array2, i));
        }
        return result;
    }

    public static <T, R> List<R> map(T[] array2, Function<? super T, ? extends R> func) {
        return Arrays.stream(array2).map(func).collect(Collectors.toList());
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (ArrayUtil.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(ArrayUtil.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(ArrayUtil.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public static <T> boolean isSub(T[] array2, T[] subArray) {
        return ArrayUtil.indexOfSub(array2, subArray) > -1;
    }

    public static <T> int indexOfSub(T[] array2, T[] subArray) {
        return ArrayUtil.indexOfSub(array2, 0, subArray);
    }

    public static <T> int indexOfSub(T[] array2, int beginInclude, T[] subArray) {
        if (ArrayUtil.isEmpty(array2) || ArrayUtil.isEmpty(subArray) || subArray.length > array2.length) {
            return -1;
        }
        int firstIndex = ArrayUtil.indexOf(array2, subArray[0], beginInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array2.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectUtil.equal(array2[i + firstIndex], subArray[i])) continue;
            return ArrayUtil.indexOfSub(array2, firstIndex + 1, subArray);
        }
        return firstIndex;
    }

    public static <T> int lastIndexOfSub(T[] array2, T[] subArray) {
        if (ArrayUtil.isEmpty(array2) || ArrayUtil.isEmpty(subArray)) {
            return -1;
        }
        return ArrayUtil.lastIndexOfSub(array2, array2.length - 1, subArray);
    }

    public static <T> int lastIndexOfSub(T[] array2, int endInclude, T[] subArray) {
        if (ArrayUtil.isEmpty(array2) || ArrayUtil.isEmpty(subArray) || subArray.length > array2.length || endInclude < 0) {
            return -1;
        }
        int firstIndex = ArrayUtil.lastIndexOf(array2, subArray[0]);
        if (firstIndex < 0 || firstIndex + subArray.length > array2.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectUtil.equal(array2[i + firstIndex], subArray[i])) continue;
            return ArrayUtil.lastIndexOfSub(array2, firstIndex - 1, subArray);
        }
        return firstIndex;
    }

    public static <T> boolean isSorted(T[] array2, Comparator<? super T> comparator2) {
        if (array2 == null || comparator2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (comparator2.compare(array2[i], array2[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array2) {
        return ArrayUtil.isSortedASC(array2);
    }

    public static <T extends Comparable<? super T>> boolean isSortedASC(T[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i].compareTo(array2[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedDESC(T[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i].compareTo(array2[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }
}

