/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import java.nio.ByteOrder;

public class ByteUtil {
    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes2) {
        return ByteUtil.bytesToShort(bytes2, ByteOrder.LITTLE_ENDIAN);
    }

    public static short bytesToShort(byte[] bytes2, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(bytes2[0] & 0xFF | (bytes2[1] & 0xFF) << 8);
        }
        return (short)(bytes2[1] & 0xFF | (bytes2[0] & 0xFF) << 8);
    }

    public static byte[] shortToBytes(short shortValue) {
        return ByteUtil.shortToBytes(shortValue, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] shortToBytes(short shortValue, ByteOrder byteOrder) {
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            b[0] = (byte)(shortValue & 0xFF);
            b[1] = (byte)(shortValue >> 8 & 0xFF);
        } else {
            b[1] = (byte)(shortValue & 0xFF);
            b[0] = (byte)(shortValue >> 8 & 0xFF);
        }
        return b;
    }

    public static int bytesToInt(byte[] bytes2) {
        return ByteUtil.bytesToInt(bytes2, ByteOrder.LITTLE_ENDIAN);
    }

    public static int bytesToInt(byte[] bytes2, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return bytes2[0] & 0xFF | (bytes2[1] & 0xFF) << 8 | (bytes2[2] & 0xFF) << 16 | (bytes2[3] & 0xFF) << 24;
        }
        return bytes2[3] & 0xFF | (bytes2[2] & 0xFF) << 8 | (bytes2[1] & 0xFF) << 16 | (bytes2[0] & 0xFF) << 24;
    }

    public static byte[] intToBytes(int intValue) {
        return ByteUtil.intToBytes(intValue, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] intToBytes(int intValue, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
        }
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] longToBytes(long longValue) {
        return ByteUtil.longToBytes(longValue, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] longToBytes(long longValue, ByteOrder byteOrder) {
        byte[] result = new byte[8];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        } else {
            for (int i = result.length - 1; i >= 0; --i) {
                result[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        }
        return result;
    }

    public static long bytesToLong(byte[] bytes2) {
        return ByteUtil.bytesToLong(bytes2, ByteOrder.LITTLE_ENDIAN);
    }

    public static long bytesToLong(byte[] bytes2, ByteOrder byteOrder) {
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)(bytes2[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)(bytes2[i] & 0xFF);
            }
        }
        return values;
    }

    public static byte[] doubleToBytes(double doubleValue) {
        return ByteUtil.doubleToBytes(doubleValue, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] doubleToBytes(double doubleValue, ByteOrder byteOrder) {
        return ByteUtil.longToBytes(Double.doubleToLongBits(doubleValue), byteOrder);
    }

    public static double bytesToDouble(byte[] bytes2) {
        return ByteUtil.bytesToDouble(bytes2, ByteOrder.LITTLE_ENDIAN);
    }

    public static double bytesToDouble(byte[] bytes2, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteUtil.bytesToLong(bytes2, byteOrder));
    }

    public static byte[] numberToBytes(Number number) {
        return ByteUtil.numberToBytes(number, ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] numberToBytes(Number number, ByteOrder byteOrder) {
        if (number instanceof Double) {
            return ByteUtil.doubleToBytes((Double)number, byteOrder);
        }
        if (number instanceof Long) {
            return ByteUtil.longToBytes((Long)number, byteOrder);
        }
        if (number instanceof Integer) {
            return ByteUtil.intToBytes((Integer)number, byteOrder);
        }
        if (number instanceof Short) {
            return ByteUtil.shortToBytes((Short)number, byteOrder);
        }
        return ByteUtil.doubleToBytes(number.doubleValue(), byteOrder);
    }
}

