/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class ReferenceUtil {
    public static <T> Reference<T> create(ReferenceType type2, T referent) {
        return ReferenceUtil.create(type2, referent, null);
    }

    public static <T> Reference<T> create(ReferenceType type2, T referent, ReferenceQueue<T> queue) {
        switch (type2) {
            case SOFT: {
                return new SoftReference<T>(referent);
            }
            case WEAK: {
                return new WeakReference<T>(referent);
            }
            case PHANTOM: {
                return new PhantomReference<T>(referent, queue);
            }
        }
        return null;
    }

    public static enum ReferenceType {
        SOFT,
        WEAK,
        PHANTOM;

    }
}

