/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.ParameterizedTypeImpl;
import cn.hutool.core.lang.reflect.ActualTypeMapperPool;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;

public class TypeUtil {
    public static Class<?> getClass(Type type2) {
        if (null != type2) {
            Type[] upperBounds;
            if (type2 instanceof Class) {
                return (Class)type2;
            }
            if (type2 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type2).getRawType();
            }
            if (type2 instanceof TypeVariable) {
                return (Class)((TypeVariable)type2).getBounds()[0];
            }
            if (type2 instanceof WildcardType && (upperBounds = ((WildcardType)type2).getUpperBounds()).length == 1) {
                return TypeUtil.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Type getFieldType(Class<?> clazz, String fieldName) {
        return TypeUtil.getType(ReflectUtil.getField(clazz, fieldName));
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index2) {
        Type[] types = TypeUtil.getParamTypes(method);
        if (null != types && types.length > index2) {
            return types[index2];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index2) {
        Class<?>[] classes = TypeUtil.getParamClasses(method);
        if (null != classes && classes.length > index2) {
            return classes[index2];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type2) {
        return TypeUtil.getTypeArgument(type2, 0);
    }

    public static Type getTypeArgument(Type type2, int index2) {
        Type[] typeArguments = TypeUtil.getTypeArguments(type2);
        if (null != typeArguments && typeArguments.length > index2) {
            return typeArguments[index2];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type2) {
        if (null == type2) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtil.toParameterizedType(type2);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type2) {
        ParameterizedType result = null;
        if (type2 instanceof ParameterizedType) {
            result = (ParameterizedType)type2;
        } else if (type2 instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type2;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && ArrayUtil.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
                genericSuper = genericInterfaces[0];
            }
            result = TypeUtil.toParameterizedType(genericSuper);
        }
        return result;
    }

    public static boolean isUnknown(Type type2) {
        return null == type2 || type2 instanceof TypeVariable;
    }

    public static boolean hasTypeVariable(Type ... types) {
        for (Type type2 : types) {
            if (!(type2 instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Map<Type, Type> getTypeMap(Class<?> clazz) {
        return ActualTypeMapperPool.get(clazz);
    }

    public static Type getActualType(Type type2, Field field) {
        if (null == field) {
            return null;
        }
        return TypeUtil.getActualType((Type)ObjectUtil.defaultIfNull(type2, field.getDeclaringClass()), field.getGenericType());
    }

    public static Type getActualType(Type type2, Type typeVariable) {
        if (typeVariable instanceof ParameterizedType) {
            return TypeUtil.getActualType(type2, (ParameterizedType)typeVariable);
        }
        if (typeVariable instanceof TypeVariable) {
            return ActualTypeMapperPool.getActualType(type2, (TypeVariable)typeVariable);
        }
        return typeVariable;
    }

    public static Type getActualType(Type type2, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (TypeUtil.hasTypeVariable(actualTypeArguments) && ArrayUtil.isNotEmpty(actualTypeArguments = TypeUtil.getActualTypes(type2, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new ParameterizedTypeImpl(actualTypeArguments, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return parameterizedType;
    }

    public static Type[] getActualTypes(Type type2, Type ... typeVariables) {
        return ActualTypeMapperPool.getActualTypes(type2, typeVariables);
    }
}

