/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.parser.ValueParser;

public class SimpleValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public SimpleValueParser(int min2, int max2) {
        if (min2 > max2) {
            this.min = max2;
            this.max = min2;
        } else {
            this.min = min2;
            this.max = max2;
        }
    }

    @Override
    public int parse(String value) throws CronException {
        int i;
        if ("L".equalsIgnoreCase(value)) {
            return this.max;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e2) {
            throw new CronException(e2, "Invalid integer value: '{}'", value);
        }
        if (i < this.min || i > this.max) {
            throw new CronException("Value {} out of range: [{} , {}]", i, this.min, this.max);
        }
        return i;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

