/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.crypto.CryptoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.util.ASN1Dump;

public class ASN1Util {
    public static byte[] encodeDer(ASN1Encodable ... elements) {
        return ASN1Util.encode("DER", elements);
    }

    public static byte[] encode(String asn1Encoding, ASN1Encodable ... elements) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        ASN1Util.encodeTo(asn1Encoding, out, elements);
        return out.toByteArray();
    }

    public static void encodeTo(String asn1Encoding, OutputStream out, ASN1Encodable ... elements) {
        DERSequence sequence2;
        switch (asn1Encoding) {
            case "DER": {
                sequence2 = new DERSequence(elements);
                break;
            }
            case "BER": {
                sequence2 = new BERSequence(elements);
                break;
            }
            case "DL": {
                sequence2 = new DLSequence(elements);
                break;
            }
            default: {
                throw new CryptoException("Unsupported ASN1 encoding: {}", asn1Encoding);
            }
        }
        try {
            sequence2.encodeTo(out);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static ASN1Object decode(InputStream in) {
        ASN1InputStream asn1In = new ASN1InputStream(in);
        try {
            return asn1In.readObject();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static String getDumpStr(InputStream in) {
        return ASN1Dump.dumpAsString((Object)ASN1Util.decode(in));
    }
}

