/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.digest.BCrypt;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.MD5;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.SecretKey;

public class DigestUtil {
    public static byte[] md5(byte[] data2) {
        return new MD5().digest(data2);
    }

    public static byte[] md5(String data2, String charset) {
        return new MD5().digest(data2, charset);
    }

    public static byte[] md5(String data2) {
        return DigestUtil.md5(data2, "UTF-8");
    }

    public static byte[] md5(InputStream data2) {
        return new MD5().digest(data2);
    }

    public static byte[] md5(File file2) {
        return new MD5().digest(file2);
    }

    public static String md5Hex(byte[] data2) {
        return new MD5().digestHex(data2);
    }

    public static String md5Hex(String data2, String charset) {
        return new MD5().digestHex(data2, charset);
    }

    public static String md5Hex(String data2, Charset charset) {
        return new MD5().digestHex(data2, charset);
    }

    public static String md5Hex(String data2) {
        return DigestUtil.md5Hex(data2, "UTF-8");
    }

    public static String md5Hex(InputStream data2) {
        return new MD5().digestHex(data2);
    }

    public static String md5Hex(File file2) {
        return new MD5().digestHex(file2);
    }

    public static String md5Hex16(byte[] data2) {
        return new MD5().digestHex16(data2);
    }

    public static String md5Hex16(String data2, Charset charset) {
        return new MD5().digestHex16(data2, charset);
    }

    public static String md5Hex16(String data2) {
        return DigestUtil.md5Hex16(data2, CharsetUtil.CHARSET_UTF_8);
    }

    public static String md5Hex16(InputStream data2) {
        return new MD5().digestHex16(data2);
    }

    public static String md5Hex16(File file2) {
        return new MD5().digestHex16(file2);
    }

    public static String md5HexTo16(String md5Hex) {
        return md5Hex.substring(8, 24);
    }

    public static byte[] sha1(byte[] data2) {
        return new Digester(DigestAlgorithm.SHA1).digest(data2);
    }

    public static byte[] sha1(String data2, String charset) {
        return new Digester(DigestAlgorithm.SHA1).digest(data2, charset);
    }

    public static byte[] sha1(String data2) {
        return DigestUtil.sha1(data2, "UTF-8");
    }

    public static byte[] sha1(InputStream data2) {
        return new Digester(DigestAlgorithm.SHA1).digest(data2);
    }

    public static byte[] sha1(File file2) {
        return new Digester(DigestAlgorithm.SHA1).digest(file2);
    }

    public static String sha1Hex(byte[] data2) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data2);
    }

    public static String sha1Hex(String data2, String charset) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data2, charset);
    }

    public static String sha1Hex(String data2) {
        return DigestUtil.sha1Hex(data2, "UTF-8");
    }

    public static String sha1Hex(InputStream data2) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data2);
    }

    public static String sha1Hex(File file2) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(file2);
    }

    public static byte[] sha256(byte[] data2) {
        return new Digester(DigestAlgorithm.SHA256).digest(data2);
    }

    public static byte[] sha256(String data2, String charset) {
        return new Digester(DigestAlgorithm.SHA256).digest(data2, charset);
    }

    public static byte[] sha256(String data2) {
        return DigestUtil.sha256(data2, "UTF-8");
    }

    public static byte[] sha256(InputStream data2) {
        return new Digester(DigestAlgorithm.SHA256).digest(data2);
    }

    public static byte[] sha256(File file2) {
        return new Digester(DigestAlgorithm.SHA256).digest(file2);
    }

    public static String sha256Hex(byte[] data2) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data2);
    }

    public static String sha256Hex(String data2, String charset) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data2, charset);
    }

    public static String sha256Hex(String data2) {
        return DigestUtil.sha256Hex(data2, "UTF-8");
    }

    public static String sha256Hex(InputStream data2) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data2);
    }

    public static String sha256Hex(File file2) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(file2);
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key2) {
        return new HMac(algorithm, key2);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key2) {
        return new HMac(algorithm, (Key)key2);
    }

    public static Digester digester(DigestAlgorithm algorithm) {
        return new Digester(algorithm);
    }

    public static Digester digester(String algorithm) {
        return new Digester(algorithm);
    }

    public static String bcrypt(String password) {
        return BCrypt.hashpw(password);
    }

    public static boolean bcryptCheck(String password, String hashed) {
        return BCrypt.checkpw(password, hashed);
    }
}

