/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.mac.MacEngine;
import cn.hutool.crypto.digest.mac.MacEngineFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MacEngine engine;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key2) {
        this(algorithm.getValue(), key2);
    }

    public HMac(HmacAlgorithm algorithm, Key key2) {
        this(algorithm.getValue(), key2);
    }

    public HMac(String algorithm, byte[] key2) {
        this(algorithm, (Key)new SecretKeySpec(key2, algorithm));
    }

    public HMac(String algorithm, Key key2) {
        this(algorithm, key2, null);
    }

    public HMac(String algorithm, Key key2, AlgorithmParameterSpec spec) {
        this(MacEngineFactory.createEngine(algorithm, key2, spec));
    }

    public HMac(MacEngine engine) {
        this.engine = engine;
    }

    public MacEngine getEngine() {
        return this.engine;
    }

    public byte[] digest(String data2, Charset charset) {
        return this.digest(StrUtil.bytes((CharSequence)data2, charset));
    }

    public byte[] digest(String data2) {
        return this.digest(data2, CharsetUtil.CHARSET_UTF_8);
    }

    public String digestBase64(String data2, boolean isUrlSafe) {
        return this.digestBase64(data2, CharsetUtil.CHARSET_UTF_8, isUrlSafe);
    }

    public String digestBase64(String data2, Charset charset, boolean isUrlSafe) {
        return Base64.encodeStr(this.digest(data2, charset), false, isUrlSafe);
    }

    public String digestHex(String data2, Charset charset) {
        return HexUtil.encodeHexStr(this.digest(data2, charset));
    }

    public String digestHex(String data2) {
        return this.digestHex(data2, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file2) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file2);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public String digestHex(File file2) {
        return HexUtil.encodeHexStr(this.digest(file2));
    }

    public byte[] digest(byte[] data2) {
        return this.digest(new ByteArrayInputStream(data2), -1);
    }

    public String digestHex(byte[] data2) {
        return HexUtil.encodeHexStr(this.digest(data2));
    }

    public byte[] digest(InputStream data2) {
        return this.digest(data2, 8192);
    }

    public String digestHex(InputStream data2) {
        return HexUtil.encodeHexStr(this.digest(data2));
    }

    public byte[] digest(InputStream data2, int bufferLength) {
        return this.engine.digest(data2, bufferLength);
    }

    public String digestHex(InputStream data2, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data2, bufferLength));
    }

    public boolean verify(byte[] digest, byte[] digestToCompare) {
        return MessageDigest.isEqual(digest, digestToCompare);
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

