/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SM4
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;
    public static final String ALGORITHM_NAME = "SM4";

    public SM4() {
        super(ALGORITHM_NAME);
    }

    public SM4(byte[] key2) {
        super(ALGORITHM_NAME, key2);
    }

    public SM4(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public SM4(Mode mode, Padding padding, byte[] key2) {
        this(mode, padding, key2, null);
    }

    public SM4(Mode mode, Padding padding, byte[] key2, byte[] iv) {
        this(mode.name(), padding.name(), key2, iv);
    }

    public SM4(Mode mode, Padding padding, SecretKey key2) {
        this(mode, padding, key2, (IvParameterSpec)null);
    }

    public SM4(Mode mode, Padding padding, SecretKey key2, byte[] iv) {
        this(mode, padding, key2, ArrayUtil.isEmpty(iv) ? null : new IvParameterSpec(iv));
    }

    public SM4(Mode mode, Padding padding, SecretKey key2, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key2, iv);
    }

    public SM4(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public SM4(String mode, String padding, byte[] key2) {
        this(mode, padding, key2, null);
    }

    public SM4(String mode, String padding, byte[] key2, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey(ALGORITHM_NAME, key2), ArrayUtil.isEmpty(iv) ? null : new IvParameterSpec(iv));
    }

    public SM4(String mode, String padding, SecretKey key2) {
        this(mode, padding, key2, null);
    }

    public SM4(String mode, String padding, SecretKey key2, IvParameterSpec iv) {
        super(StrUtil.format("SM4/{}/{}", mode, padding), key2, iv);
    }
}

