/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric.fpe;

import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.jcajce.spec.FPEParameterSpec;

public class FPE
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AES aes;
    private final AlphabetMapper mapper;

    public FPE(FPEMode mode, byte[] key2, AlphabetMapper mapper) {
        this(mode, key2, mapper, null);
    }

    public FPE(FPEMode mode, byte[] key2, AlphabetMapper mapper, byte[] tweak) {
        if (null == mode) {
            mode = FPEMode.FF1;
        }
        if (null == tweak) {
            switch (mode) {
                case FF1: {
                    tweak = new byte[]{};
                    break;
                }
                case FF3_1: {
                    tweak = new byte[7];
                }
            }
        }
        this.aes = new AES(mode.value, Padding.NoPadding.name(), KeyUtil.generateKey(mode.value, key2), (AlgorithmParameterSpec)new FPEParameterSpec(mapper.getRadix(), tweak));
        this.mapper = mapper;
    }

    public String encrypt(String data2) {
        if (null == data2) {
            return null;
        }
        return new String(this.encrypt(data2.toCharArray()));
    }

    public char[] encrypt(char[] data2) {
        if (null == data2) {
            return null;
        }
        return this.mapper.convertToChars(this.aes.encrypt(this.mapper.convertToIndexes(data2)));
    }

    public String decrypt(String data2) {
        if (null == data2) {
            return null;
        }
        return new String(this.decrypt(data2.toCharArray()));
    }

    public char[] decrypt(char[] data2) {
        if (null == data2) {
            return null;
        }
        return this.mapper.convertToChars(this.aes.decrypt(this.mapper.convertToIndexes(data2)));
    }

    public static enum FPEMode {
        FF1("FF1"),
        FF3_1("FF3-1");

        private final String value;

        private FPEMode(String name2) {
            this.value = name2;
        }

        public String getValue() {
            return this.value;
        }
    }
}

