/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.mongo;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.db.nosql.mongo.MongoDS;
import cn.hutool.setting.Setting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MongoFactory {
    private static final String GROUP_SEPRATER = ",";
    private static final Map<String, MongoDS> DS_MAP = new ConcurrentHashMap<String, MongoDS>();

    public static MongoDS getDS(String host, int port) {
        String key2 = host + ":" + port;
        MongoDS ds = DS_MAP.get(key2);
        if (null == ds) {
            ds = new MongoDS(host, port);
            DS_MAP.put(key2, ds);
        }
        return ds;
    }

    public static MongoDS getDS(String ... groups) {
        String key2 = ArrayUtil.join(groups, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = DS_MAP.get(key2);
        if (null == ds) {
            ds = new MongoDS(groups);
            DS_MAP.put(key2, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Collection<String> groups) {
        return MongoFactory.getDS(groups.toArray(new String[0]));
    }

    public static MongoDS getDS(Setting setting, String ... groups) {
        String key2 = setting.getSettingPath() + GROUP_SEPRATER + ArrayUtil.join(groups, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = DS_MAP.get(key2);
        if (null == ds) {
            ds = new MongoDS(setting, groups);
            DS_MAP.put(key2, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Setting setting, Collection<String> groups) {
        return MongoFactory.getDS(setting, groups.toArray(new String[0]));
    }

    public static void closeAll() {
        if (MapUtil.isNotEmpty(DS_MAP)) {
            for (MongoDS ds : DS_MAP.values()) {
                ds.close();
            }
            DS_MAP.clear();
        }
    }

    static {
        RuntimeUtil.addShutdownHook(MongoFactory::closeAll);
    }
}

