/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.pinyin;

import cn.hutool.extra.pinyin.PinyinEngine;
import cn.hutool.extra.pinyin.engine.PinyinFactory;

public class PinyinUtil {
    private static final String CHINESE_REGEX = "[\\u4e00-\\u9fa5]";

    public static PinyinEngine getEngine() {
        return PinyinFactory.get();
    }

    public static String getPinyin(char c) {
        return PinyinUtil.getEngine().getPinyin(c);
    }

    public static String getPinyin(String str2) {
        return PinyinUtil.getPinyin(str2, " ");
    }

    public static String getPinyin(String str2, String separator) {
        return PinyinUtil.getEngine().getPinyin(str2, separator);
    }

    public static char getFirstLetter(char c) {
        return PinyinUtil.getEngine().getFirstLetter(c);
    }

    public static String getFirstLetter(String str2, String separator) {
        return PinyinUtil.getEngine().getFirstLetter(str2, separator);
    }

    public static boolean isChinese(char c) {
        return '\u3007' == c || String.valueOf(c).matches(CHINESE_REGEX);
    }
}

