/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.servlet;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.net.multipart.MultipartFormData;
import cn.hutool.core.net.multipart.UploadSetting;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtil {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map<String, String[]> map2 = request.getParameterMap();
        return Collections.unmodifiableMap(map2);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtil.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBody(ServletRequest request) {
        try (BufferedReader reader2 = request.getReader();){
            String string2 = IoUtil.read(reader2);
            return string2;
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtil.readBytes(request.getInputStream());
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean2, CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst(bean2.getClass().getSimpleName());
        return BeanUtil.fillBean(bean2, new ValueProvider<String>(){

            @Override
            public Object value(String key2, Type valueType) {
                String[] values = request.getParameterValues(key2);
                if (ArrayUtil.isEmpty(values) && ArrayUtil.isEmpty(values = request.getParameterValues(beanName + "." + key2))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return values;
            }

            @Override
            public boolean containsKey(String key2) {
                return null != request.getParameter(key2) || null != request.getParameter(beanName + "." + key2);
            }
        }, copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean2, boolean isIgnoreError) {
        return ServletUtil.fillBean(request, bean2, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return ServletUtil.fillBean(request, ReflectUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            headers = ArrayUtil.addAll(headers, otherHeaderNames);
        }
        return ServletUtil.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown(ip)) continue;
            return NetUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp(ip);
    }

    public static MultipartFormData getMultipart(ServletRequest request) throws IORuntimeException {
        return ServletUtil.getMultipart(request, new UploadSetting());
    }

    public static MultipartFormData getMultipart(ServletRequest request, UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream(request.getInputStream(), CharsetUtil.charset(request.getCharacterEncoding()));
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return formData;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name2 = names.nextElement();
            headerMap.put(name2, request.getHeader(name2));
        }
        return headerMap;
    }

    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name2 = names.nextElement();
            if (name2 == null || !name2.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name2);
        }
        return null;
    }

    public static String getHeader(HttpServletRequest request, String name2, String charsetName) {
        return ServletUtil.getHeader(request, name2, CharsetUtil.charset(charsetName));
    }

    public static String getHeader(HttpServletRequest request, String name2, Charset charset) {
        String header = request.getHeader(name2);
        if (null != header) {
            return CharsetUtil.convert(header, CharsetUtil.CHARSET_ISO_8859_1, charset);
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = ServletUtil.getHeaderIgnoreCase(request, "User-Agent");
        if (StrUtil.isNotBlank(userAgent)) {
            return (userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return METHOD_GET.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return METHOD_POST.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!ServletUtil.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StrUtil.isBlank(contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name2) {
        return ServletUtil.readCookieMap(httpServletRequest).get(name2);
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        Cookie[] cookies = httpServletRequest.getCookies();
        if (ArrayUtil.isEmpty(cookies)) {
            return MapUtil.empty();
        }
        return IterUtil.toMap(new ArrayIter<Cookie>((E[])httpServletRequest.getCookies()), new CaseInsensitiveMap(), Cookie::getName);
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name2, String value) {
        response.addCookie(new Cookie(name2, value));
    }

    public static void addCookie(HttpServletResponse response, String name2, String value, int maxAgeInSeconds, String path2, String domain) {
        Cookie cookie = new Cookie(name2, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path2);
        ServletUtil.addCookie(response, cookie);
    }

    public static void addCookie(HttpServletResponse response, String name2, String value, int maxAgeInSeconds) {
        ServletUtil.addCookie(response, name2, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IORuntimeException {
        try {
            return response.getWriter();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer2 = null;
        try {
            writer2 = response.getWriter();
            ((Writer)writer2).write(text);
            ((Writer)writer2).flush();
        }
        catch (IOException e2) {
            throw new UtilException(e2);
        }
        finally {
            IoUtil.close(writer2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, File file2) {
        String fileName = file2.getName();
        String contentType = ObjectUtil.defaultIfNull(FileUtil.getMimeType(fileName), "application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file2);
            ServletUtil.write(response, in, contentType, fileName);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        String charset = ObjectUtil.defaultIfNull(response.getCharacterEncoding(), "UTF-8");
        response.setHeader("Content-Disposition", StrUtil.format("attachment;filename={}", URLUtil.encode(fileName, CharsetUtil.charset(charset))));
        response.setContentType(contentType);
        ServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        ServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        ServletUtil.write(response, in, 8192);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoUtil.copy(in, out, bufferSize);
        }
        catch (IOException e2) {
            throw new UtilException(e2);
        }
        finally {
            IoUtil.close(out);
            IoUtil.close(in);
        }
    }

    public static void setHeader(HttpServletResponse response, String name2, Object value) {
        if (value instanceof String) {
            response.setHeader(name2, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name2, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equalsIgnoreCase(value.getClass().getSimpleName())) {
            response.setIntHeader(name2, (Integer)value);
        } else {
            response.setHeader(name2, value.toString());
        }
    }
}

