/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Console;
import cn.hutool.core.thread.GlobalThreadPool;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.server.HttpServerRequest;
import cn.hutool.http.server.HttpServerResponse;
import cn.hutool.http.server.action.Action;
import cn.hutool.http.server.action.RootAction;
import cn.hutool.http.server.filter.HttpFilter;
import cn.hutool.http.server.filter.SimpleFilter;
import cn.hutool.http.server.handler.ActionHandler;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class SimpleServer {
    private final HttpServer server;
    private final List<Filter> filters;

    public SimpleServer(int port) {
        this(new InetSocketAddress(port));
    }

    public SimpleServer(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public SimpleServer(InetSocketAddress address) {
        this(address, null);
    }

    public SimpleServer(InetSocketAddress address, HttpsConfigurator configurator) {
        try {
            if (null != configurator) {
                HttpsServer server2 = HttpsServer.create(address, 0);
                server2.setHttpsConfigurator(configurator);
                this.server = server2;
            } else {
                this.server = HttpServer.create(address, 0);
            }
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        this.setExecutor(GlobalThreadPool.getExecutor());
        this.filters = new ArrayList<Filter>();
    }

    public SimpleServer addFilter(Filter filter2) {
        this.filters.add(filter2);
        return this;
    }

    public SimpleServer addFilter(final HttpFilter filter2) {
        return this.addFilter(new SimpleFilter(){

            @Override
            public void doFilter(HttpExchange httpExchange, Filter.Chain chain) throws IOException {
                filter2.doFilter(new HttpServerRequest(httpExchange), new HttpServerResponse(httpExchange), chain);
            }
        });
    }

    public SimpleServer addHandler(String path2, HttpHandler handler) {
        this.createContext(path2, handler);
        return this;
    }

    public HttpContext createContext(String path2, HttpHandler handler) {
        path2 = StrUtil.addPrefixIfNot(path2, "/");
        HttpContext context = this.server.createContext(path2, handler);
        context.getFilters().addAll(this.filters);
        return context;
    }

    public SimpleServer setRoot(String root2) {
        return this.setRoot(new File(root2));
    }

    public SimpleServer setRoot(File root2) {
        return this.addAction("/", new RootAction(root2));
    }

    public SimpleServer addAction(String path2, Action action) {
        return this.addHandler(path2, new ActionHandler(action));
    }

    public SimpleServer setExecutor(Executor executor) {
        this.server.setExecutor(executor);
        return this;
    }

    public HttpServer getRawServer() {
        return this.server;
    }

    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    public void start() {
        InetSocketAddress address = this.getAddress();
        Console.log("Hutool Simple Http Server listen on \u3010{}:{}\u3011", address.getHostName(), address.getPort());
        this.server.start();
    }
}

