/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.http.server.HttpServerRequest;
import cn.hutool.http.server.HttpServerResponse;
import cn.hutool.http.server.action.Action;
import java.io.File;
import java.util.List;

public class RootAction
implements Action {
    public static final String DEFAULT_INDEX_FILE_NAME = "index.html";
    private final File rootDir;
    private final List<String> indexFileNames;

    public RootAction(String rootDir) {
        this(new File(rootDir));
    }

    public RootAction(File rootDir) {
        this(rootDir, DEFAULT_INDEX_FILE_NAME);
    }

    public RootAction(String rootDir, String ... indexFileNames) {
        this(new File(rootDir), indexFileNames);
    }

    public RootAction(File rootDir, String ... indexFileNames) {
        this.rootDir = rootDir;
        this.indexFileNames = CollUtil.toList(indexFileNames);
    }

    @Override
    public void doAction(HttpServerRequest request, HttpServerResponse response) {
        String path2 = request.getPath();
        File file2 = FileUtil.file(this.rootDir, path2);
        if (file2.exists()) {
            if (file2.isDirectory()) {
                for (String indexFileName : this.indexFileNames) {
                    if (!(file2 = FileUtil.file(file2, indexFileName)).exists() || !file2.isFile()) continue;
                    response.write(file2);
                }
            } else {
                String name2 = request.getParam("name");
                response.write(file2, name2);
            }
        }
        response.send404("404 Not Found !");
    }
}

