/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;

public final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return JSONNull.NULL.toString();
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map2 = (Map)value;
            return new JSONObject(map2).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray((Object)coll).toString();
        }
        if (ArrayUtil.isArray(value)) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    public static Object stringToValue(String string2) {
        if (StrUtil.isEmpty(string2) || "null".equalsIgnoreCase(string2)) {
            return JSONNull.NULL;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return Boolean.FALSE;
        }
        char b = string2.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase(string2, ".", "e")) {
                    return new BigDecimal(string2);
                }
                long myLong = Long.parseLong(string2);
                if (string2.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    static JSONObject propertyPut(JSONObject jsonObject, Object key2, Object value) {
        String[] path2 = StrUtil.splitToArray((CharSequence)Convert.toStr(key2), '.');
        int last = path2.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path2[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.getConfig());
                target.set(segment, nextTarget);
            }
            target = nextTarget;
        }
        target.set(path2[last], value);
        return jsonObject;
    }

    static boolean defaultIgnoreNullValue(Object obj) {
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == obj instanceof Map;
    }

    static boolean isOrder(Object value) {
        JSONConfig config;
        if (value instanceof LinkedHashMap || value instanceof SortedMap) {
            return true;
        }
        if (value instanceof JSONGetter && null != (config = ((JSONGetter)value).getConfig())) {
            return config.isOrder();
        }
        return false;
    }
}

