/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;

public interface JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public JSONConfig getConfig();

    default public boolean isNull(K key2) {
        return JSONNull.NULL.equals(this.getObj(key2));
    }

    default public String getStrEscaped(K key2) {
        return this.getStrEscaped(key2, null);
    }

    default public String getStrEscaped(K key2, String defaultValue) {
        return JSONUtil.escape(this.getStr(key2, defaultValue));
    }

    default public JSONArray getJSONArray(K key2) {
        Object object = this.getObj(key2);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONArray)object;
        }
        return new JSONArray(object, this.getConfig());
    }

    default public JSONObject getJSONObject(K key2) {
        Object object = this.getObj(key2);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONObject)object;
        }
        return new JSONObject(object, this.getConfig());
    }

    default public <T> T getBean(K key2, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key2);
        return null == obj ? null : (T)obj.toBean(beanType);
    }

    @Override
    default public Date getDate(K key2, Date defaultValue) {
        String format2;
        Object obj = this.getObj(key2);
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        Optional<String> formatOps = Optional.ofNullable(this.getConfig()).map(JSONConfig::getDateFormat);
        if (formatOps.isPresent() && StrUtil.isNotBlank(format2 = formatOps.get())) {
            String str2 = Convert.toStr(obj);
            if (null == str2) {
                return defaultValue;
            }
            return DateUtil.parse((CharSequence)str2, format2);
        }
        return Convert.toDate(obj, defaultValue);
    }

    default public LocalDateTime getLocalDateTime(K key2, LocalDateTime defaultValue) {
        String format2;
        Object obj = this.getObj(key2);
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        Optional<String> formatOps = Optional.ofNullable(this.getConfig()).map(JSONConfig::getDateFormat);
        if (formatOps.isPresent() && StrUtil.isNotBlank(format2 = formatOps.get())) {
            String str2 = Convert.toStr(obj);
            if (null == str2) {
                return defaultValue;
            }
            return LocalDateTimeUtil.parse((CharSequence)str2, format2);
        }
        return Convert.toLocalDateTime(obj, defaultValue);
    }

    default public <T> T get(K key2, Class<T> type2) throws ConvertException {
        return this.get(key2, type2, false);
    }

    default public <T> T get(K key2, Class<T> type2, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key2);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type2, value, ignoreError);
    }
}

