/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.util.StrUtil;

public class JSONStrFormatter {
    private static final String SPACE = "    ";
    private static final char NEW_LINE = '\n';

    public static String format(String json) {
        StringBuilder result = new StringBuilder();
        Character wrapChar = null;
        boolean isEscapeMode = false;
        int length = json.length();
        int number = 0;
        for (int i = 0; i < length; ++i) {
            char key2 = json.charAt(i);
            if ('\"' == key2 || '\'' == key2) {
                if (null == wrapChar) {
                    wrapChar = Character.valueOf(key2);
                } else if (isEscapeMode) {
                    isEscapeMode = false;
                } else if (wrapChar.equals(Character.valueOf(key2))) {
                    wrapChar = null;
                }
                if (i > 1 && json.charAt(i - 1) == ':') {
                    result.append(' ');
                }
                result.append(key2);
                continue;
            }
            if ('\\' == key2) {
                if (null != wrapChar) {
                    isEscapeMode = !isEscapeMode;
                    result.append(key2);
                    continue;
                }
                result.append(key2);
            }
            if (null != wrapChar) {
                result.append(key2);
                continue;
            }
            if (key2 == '[' || key2 == '{') {
                if (i > 1 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(JSONStrFormatter.indent(number));
                }
                result.append(key2);
                result.append('\n');
                result.append(JSONStrFormatter.indent(++number));
                continue;
            }
            if (key2 == ']' || key2 == '}') {
                result.append('\n');
                result.append(JSONStrFormatter.indent(--number));
                result.append(key2);
                continue;
            }
            if (key2 == ',') {
                result.append(key2);
                result.append('\n');
                result.append(JSONStrFormatter.indent(number));
                continue;
            }
            if (i > 1 && json.charAt(i - 1) == ':') {
                result.append(' ');
            }
            result.append(key2);
        }
        return result.toString();
    }

    private static String indent(int number) {
        return StrUtil.repeat(SPACE, number);
    }
}

