/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.json.JSON;
import cn.hutool.json.serialize.JSONArraySerializer;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalSerializeMapping {
    private static Map<Type, JSONSerializer<? extends JSON, ?>> serializerMap;
    private static Map<Type, JSONDeserializer<?>> deserializerMap;

    public static void put(Type type2, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type2, serializer);
    }

    public static void put(Type type2, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type2, serializer);
    }

    private static synchronized void putInternal(Type type2, JSONSerializer<? extends JSON, ?> serializer) {
        if (null == serializerMap) {
            serializerMap = new ConcurrentHashMap();
        }
        serializerMap.put(type2, serializer);
    }

    public static synchronized void put(Type type2, JSONDeserializer<?> deserializer) {
        if (null == deserializerMap) {
            deserializerMap = new ConcurrentHashMap();
        }
        deserializerMap.put(type2, deserializer);
    }

    public static JSONSerializer<? extends JSON, ?> getSerializer(Type type2) {
        if (null == serializerMap) {
            return null;
        }
        return serializerMap.get(type2);
    }

    public static JSONDeserializer<?> getDeserializer(Type type2) {
        if (null == deserializerMap) {
            return null;
        }
        return deserializerMap.get(type2);
    }
}

