/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter
extends Writer {
    private final int indentFactor;
    private final int indent;
    private final Writer writer;
    private final JSONConfig config;
    private boolean needSeparator;
    private boolean arrayMode;

    public static JSONWriter of(Writer writer2, int indentFactor, int indent2, JSONConfig config) {
        return new JSONWriter(writer2, indentFactor, indent2, config);
    }

    public JSONWriter(Writer writer2, int indentFactor, int indent2, JSONConfig config) {
        this.writer = writer2;
        this.indentFactor = indentFactor;
        this.indent = indent2;
        this.config = config;
    }

    public JSONWriter beginObj() {
        this.writeRaw('{');
        return this;
    }

    public JSONWriter beginArray() {
        this.writeRaw('[');
        this.arrayMode = true;
        return this;
    }

    public JSONWriter end() {
        this.writeLF().writeSpace(this.indent);
        this.writeRaw(this.arrayMode ? (char)']' : '}');
        this.flush();
        this.arrayMode = false;
        this.needSeparator = true;
        return this;
    }

    public JSONWriter writeKey(String key2) {
        if (this.needSeparator) {
            this.writeRaw(',');
        }
        this.writeLF().writeSpace(this.indentFactor + this.indent);
        return this.writeRaw(JSONUtil.quote(key2));
    }

    public JSONWriter writeValue(Object value) {
        if (JSONUtil.isNull(value) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeValueDirect(value);
    }

    public JSONWriter writeField(String key2, Object value) {
        if (JSONUtil.isNull(value) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeKey(key2).writeValueDirect(value);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private JSONWriter writeValueDirect(Object value) {
        if (this.arrayMode) {
            if (this.needSeparator) {
                this.writeRaw(',');
            }
            this.writeLF().writeSpace(this.indentFactor + this.indent);
        } else {
            this.writeRaw(':').writeSpace(1);
        }
        this.needSeparator = true;
        return this.writeObjValue(value);
    }

    private JSONWriter writeObjValue(Object value) {
        int indent2 = this.indentFactor + this.indent;
        if (value == null || value instanceof JSONNull) {
            this.writeRaw(JSONNull.NULL.toString());
        } else if (value instanceof JSON) {
            ((JSON)value).write(this.writer, this.indentFactor, indent2);
        } else if (value instanceof Map) {
            new JSONObject(value).write(this.writer, this.indentFactor, indent2);
        } else if (value instanceof Iterable || value instanceof Iterator || ArrayUtil.isArray(value)) {
            new JSONArray(value).write(this.writer, this.indentFactor, indent2);
        } else if (value instanceof Number) {
            this.writeNumberValue((Number)value);
        } else if (value instanceof Date || value instanceof Calendar || value instanceof TemporalAccessor) {
            String format2 = null == this.config ? null : this.config.getDateFormat();
            this.writeRaw(JSONWriter.formatDate(value, format2));
        } else if (value instanceof Boolean) {
            this.writeBooleanValue((Boolean)value);
        } else if (value instanceof JSONString) {
            this.writeJSONStringValue((JSONString)value);
        } else {
            this.writeStrValue(value.toString());
        }
        return this;
    }

    private JSONWriter writeNumberValue(Number number) {
        boolean isStripTrailingZeros = null == this.config || this.config.isStripTrailingZeros();
        return this.writeRaw(NumberUtil.toStr(number, isStripTrailingZeros));
    }

    private JSONWriter writeBooleanValue(Boolean value) {
        return this.writeRaw(value.toString());
    }

    private JSONWriter writeJSONStringValue(JSONString jsonString) {
        String valueStr;
        try {
            valueStr = jsonString.toJSONString();
        }
        catch (Exception e2) {
            throw new JSONException(e2);
        }
        if (null != valueStr) {
            this.writeRaw(valueStr);
        } else {
            this.writeStrValue(jsonString.toString());
        }
        return this;
    }

    private JSONWriter writeStrValue(String csq) {
        try {
            JSONUtil.quote(csq, this.writer);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return this;
    }

    private JSONWriter writeSpace(int count2) {
        if (this.indentFactor > 0) {
            for (int i = 0; i < count2; ++i) {
                this.writeRaw(' ');
            }
        }
        return this;
    }

    private JSONWriter writeLF() {
        if (this.indentFactor > 0) {
            this.writeRaw('\n');
        }
        return this;
    }

    private JSONWriter writeRaw(String csq) {
        try {
            this.writer.append(csq);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return this;
    }

    private JSONWriter writeRaw(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return this;
    }

    private static String formatDate(Object dateObj, String format2) {
        long timeMillis;
        if (StrUtil.isNotBlank(format2)) {
            String dateStr = dateObj instanceof TemporalAccessor ? TemporalAccessorUtil.format((TemporalAccessor)dateObj, format2) : DateUtil.format(Convert.toDate(dateObj), format2);
            if ("#sss".equals(format2) || "#SSS".equals(format2)) {
                return dateStr;
            }
            return JSONUtil.quote(dateStr);
        }
        if (dateObj instanceof TemporalAccessor) {
            timeMillis = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)dateObj);
        } else if (dateObj instanceof Date) {
            timeMillis = ((Date)dateObj).getTime();
        } else if (dateObj instanceof Calendar) {
            timeMillis = ((Calendar)dateObj).getTimeInMillis();
        } else {
            throw new UnsupportedOperationException("Unsupported Date type: " + dateObj.getClass());
        }
        return String.valueOf(timeMillis);
    }
}

