/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt;

import cn.hutool.jwt.JWT;
import cn.hutool.jwt.signers.JWTSigner;
import java.util.Map;

public class JWTUtil {
    public static String createToken(Map<String, Object> payload, byte[] key2) {
        return JWTUtil.createToken(null, payload, key2);
    }

    public static String createToken(Map<String, Object> headers, Map<String, Object> payload, byte[] key2) {
        return JWT.create().addHeaders(headers).addPayloads(payload).setKey(key2).sign();
    }

    public static String createToken(Map<String, Object> payload, JWTSigner signer) {
        return JWTUtil.createToken(null, payload, signer);
    }

    public static String createToken(Map<String, Object> headers, Map<String, Object> payload, JWTSigner signer) {
        return JWT.create().addHeaders(headers).addPayloads(payload).setSigner(signer).sign();
    }

    public static JWT parseToken(String token) {
        return JWT.of(token);
    }

    public static boolean verify(String token, byte[] key2) {
        return JWT.of(token).setKey(key2).verify();
    }

    public static boolean verify(String token, JWTSigner signer) {
        return JWT.of(token).verify(signer);
    }
}

