/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.jwt.signers.JWTSigner;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class AsymmetricJWTSigner
implements JWTSigner {
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private final Sign sign;

    public AsymmetricJWTSigner(String algorithm, Key key2) {
        PublicKey publicKey = key2 instanceof PublicKey ? (PublicKey)key2 : null;
        PrivateKey privateKey = key2 instanceof PrivateKey ? (PrivateKey)key2 : null;
        this.sign = new Sign(algorithm, privateKey, publicKey);
    }

    public AsymmetricJWTSigner(String algorithm, KeyPair keyPair) {
        this.sign = new Sign(algorithm, keyPair);
    }

    public AsymmetricJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        return Base64.encodeUrlSafe(this.sign.sign(StrUtil.format("{}.{}", headerBase64, payloadBase64)));
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        return this.sign.verify(StrUtil.bytes((CharSequence)StrUtil.format("{}.{}", headerBase64, payloadBase64), this.charset), Base64.decode(signBase64));
    }

    @Override
    public String getAlgorithm() {
        return this.sign.getSignature().getAlgorithm();
    }
}

