/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.cell.values;

import cn.hutool.core.date.DateUtil;
import cn.hutool.poi.excel.ExcelDateUtil;
import cn.hutool.poi.excel.cell.CellValue;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.NumberToTextConverter;

public class NumericCellValue
implements CellValue<Object> {
    private final Cell cell;

    public NumericCellValue(Cell cell) {
        this.cell = cell;
    }

    @Override
    public Object getValue() {
        double value = this.cell.getNumericCellValue();
        CellStyle style = this.cell.getCellStyle();
        if (null != style) {
            long longPart;
            if (ExcelDateUtil.isDateFormat(this.cell)) {
                return DateUtil.date(this.cell.getDateCellValue());
            }
            String format2 = style.getDataFormatString();
            if (null != format2 && format2.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }
}

