/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.OptNullBasicTypeFromStringGetter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.Serializable;
import java.lang.reflect.Type;

public abstract class AbsSetting
implements OptNullBasicTypeFromStringGetter<String>,
Serializable {
    private static final long serialVersionUID = 6200156302595905863L;
    private static final Log log = LogFactory.get();
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_GROUP = "";

    @Override
    public String getStr(String key2, String defaultValue) {
        return this.getStr(key2, DEFAULT_GROUP, defaultValue);
    }

    public String getStr(String key2, String group, String defaultValue) {
        String value = this.getByGroup(key2, group);
        return ObjectUtil.defaultIfNull(value, defaultValue);
    }

    public String getStrNotEmpty(String key2, String group, String defaultValue) {
        String value = this.getByGroup(key2, group);
        return ObjectUtil.defaultIfEmpty(value, defaultValue);
    }

    public abstract String getByGroup(String var1, String var2);

    public String getWithLog(String key2) {
        String value = this.getStr(key2);
        if (value == null) {
            log.debug("No key define for [{}]!", key2);
        }
        return value;
    }

    public String getByGroupWithLog(String key2, String group) {
        String value = this.getByGroup(key2, group);
        if (value == null) {
            log.debug("No key define for [{}] of group [{}] !", key2, group);
        }
        return value;
    }

    public String[] getStrings(String key2) {
        return this.getStrings(key2, null);
    }

    public String[] getStringsWithDefault(String key2, String[] defaultValue) {
        String[] value = this.getStrings(key2, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key2, String group) {
        return this.getStrings(key2, group, DEFAULT_DELIMITER);
    }

    public String[] getStrings(String key2, String group, String delimiter) {
        String value = this.getByGroup(key2, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return StrUtil.splitToArray((CharSequence)value, delimiter);
    }

    public Integer getInt(String key2, String group) {
        return this.getInt(key2, group, null);
    }

    public Integer getInt(String key2, String group, Integer defaultValue) {
        return Convert.toInt(this.getByGroup(key2, group), defaultValue);
    }

    public Boolean getBool(String key2, String group) {
        return this.getBool(key2, group, null);
    }

    public Boolean getBool(String key2, String group, Boolean defaultValue) {
        return Convert.toBool(this.getByGroup(key2, group), defaultValue);
    }

    public Long getLong(String key2, String group) {
        return this.getLong(key2, group, null);
    }

    public Long getLong(String key2, String group, Long defaultValue) {
        return Convert.toLong(this.getByGroup(key2, group), defaultValue);
    }

    public Character getChar(String key2, String group) {
        String value = this.getByGroup(key2, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key2, String group) {
        return this.getDouble(key2, group, null);
    }

    public Double getDouble(String key2, String group, Double defaultValue) {
        return Convert.toDouble(this.getByGroup(key2, group), defaultValue);
    }

    public <T> T toBean(final String group, T bean2) {
        return BeanUtil.fillBean(bean2, new ValueProvider<String>(){

            @Override
            public Object value(String key2, Type valueType) {
                return AbsSetting.this.getByGroup(key2, group);
            }

            @Override
            public boolean containsKey(String key2) {
                return null != AbsSetting.this.getByGroup(key2, group);
            }
        }, CopyOptions.create());
    }

    public <T> T toBean(String group, Class<T> beanClass) {
        return this.toBean(group, ReflectUtil.newInstanceIfPossible(beanClass));
    }

    public <T> T toBean(T bean2) {
        return this.toBean(null, bean2);
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean((String)null, beanClass);
    }
}

