/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.WatchUtil;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.StaticLog;
import cn.hutool.setting.AbsSetting;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.SettingLoader;
import cn.hutool.setting.dialect.Props;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

public class Setting
extends AbsSetting
implements Map<String, String> {
    private static final long serialVersionUID = 3618305164959883393L;
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    public static final String EXT_NAME = "setting";
    private final GroupedMap groupedMap = new GroupedMap();
    protected Charset charset;
    protected boolean isUseVariable;
    protected Resource resource;
    private SettingLoader settingLoader;
    private WatchMonitor watchMonitor;

    public static Setting create() {
        return new Setting();
    }

    public Setting() {
        this.charset = DEFAULT_CHARSET;
    }

    public Setting(String path2) {
        this(path2, false);
    }

    public Setting(String path2, boolean isUseVariable) {
        this(path2, DEFAULT_CHARSET, isUseVariable);
    }

    public Setting(String path2, Charset charset, boolean isUseVariable) {
        Assert.notBlank(path2, "Blank setting path !", new Object[0]);
        this.init(ResourceUtil.getResourceObj(path2), charset, isUseVariable);
    }

    public Setting(File configFile, Charset charset, boolean isUseVariable) {
        Assert.notNull(configFile, "Null setting file define!", new Object[0]);
        this.init(new FileResource(configFile), charset, isUseVariable);
    }

    public Setting(String path2, Class<?> clazz, Charset charset, boolean isUseVariable) {
        Assert.notBlank(path2, "Blank setting path !", new Object[0]);
        this.init(new ClassPathResource(path2, clazz), charset, isUseVariable);
    }

    public Setting(URL url, Charset charset, boolean isUseVariable) {
        Assert.notNull(url, "Null setting url define!", new Object[0]);
        this.init(new UrlResource(url), charset, isUseVariable);
    }

    public Setting(Resource resource2, Charset charset, boolean isUseVariable) {
        this.init(resource2, charset, isUseVariable);
    }

    public boolean init(Resource resource2, Charset charset, boolean isUseVariable) {
        Assert.notNull(resource2, "Setting resource must be not null!", new Object[0]);
        this.resource = resource2;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
        return this.load();
    }

    public synchronized boolean load() {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this.groupedMap, this.charset, this.isUseVariable);
        }
        return this.settingLoader.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        this.autoLoad(autoReload, null);
    }

    public void autoLoad(boolean autoReload, final Consumer<Boolean> callback) {
        if (autoReload) {
            Assert.notNull(this.resource, "Setting resource must be not null !", new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    boolean success = Setting.this.load();
                    if (callback != null) {
                        callback.accept(success);
                    }
                }
            });
            this.watchMonitor.start();
            StaticLog.debug("Auto load for [{}] listenning...", this.resource.getUrl());
        } else {
            IoUtil.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public URL getSettingUrl() {
        return null == this.resource ? null : this.resource.getUrl();
    }

    public String getSettingPath() {
        URL settingUrl = this.getSettingUrl();
        return null == settingUrl ? null : settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.groupedMap.size();
    }

    @Override
    public String getByGroup(String key2, String group) {
        return this.groupedMap.get(group, key2);
    }

    public Object getAndRemove(String ... keys2) {
        String key2;
        String value = null;
        String[] stringArray = keys2;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key2 = stringArray[i])); ++i) {
        }
        return value;
    }

    public String getAndRemoveStr(String ... keys2) {
        String key2;
        String value = null;
        String[] stringArray = keys2;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key2 = stringArray[i])); ++i) {
        }
        return value;
    }

    public Map<String, String> getMap(String group) {
        Object map2 = this.groupedMap.get(group);
        return null != map2 ? map2 : new LinkedHashMap(0);
    }

    public Setting getSetting(String group) {
        Setting setting = new Setting();
        setting.putAll((Map<? extends String, ? extends String>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public Props getProps(String group) {
        Props props = new Props();
        props.putAll(this.getMap(group));
        return props;
    }

    public void store() {
        URL resourceUrl = this.getSettingUrl();
        Assert.notNull(resourceUrl, "Setting path must be not null !", new Object[0]);
        this.store(FileUtil.file(resourceUrl));
    }

    public void store(String absolutePath) {
        this.store(FileUtil.touch(absolutePath));
    }

    public void store(File file2) {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this.groupedMap, this.charset, this.isUseVariable);
        }
        this.settingLoader.store(file2);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            String group = groupEntry.getKey();
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                properties.setProperty(StrUtil.isEmpty(group) ? entry.getKey() : group + '.' + entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    public GroupedMap getGroupedMap() {
        return this.groupedMap;
    }

    public List<String> getGroups() {
        return CollUtil.newArrayList(this.groupedMap.keySet());
    }

    public Setting setVarRegex(String regex) {
        if (null == this.settingLoader) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.settingLoader.setVarRegex(regex);
        return this;
    }

    public Setting setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public boolean isEmpty(String group) {
        return this.groupedMap.isEmpty(group);
    }

    public boolean containsKey(String group, String key2) {
        return this.groupedMap.containsKey(group, key2);
    }

    public boolean containsValue(String group, String value) {
        return this.groupedMap.containsValue(group, value);
    }

    public String get(String group, String key2) {
        return this.groupedMap.get(group, key2);
    }

    public String putByGroup(String key2, String group, String value) {
        return this.groupedMap.put(group, key2, value);
    }

    public String remove(String group, Object key2) {
        return this.groupedMap.remove(group, Convert.toStr(key2));
    }

    public Setting putAll(String group, Map<? extends String, ? extends String> m) {
        this.groupedMap.putAll(group, m);
        return this;
    }

    public Setting addSetting(Setting setting) {
        for (Map.Entry<String, LinkedHashMap<String, String>> e2 : setting.getGroupedMap().entrySet()) {
            this.putAll(e2.getKey(), (Map<? extends String, ? extends String>)e2.getValue());
        }
        return this;
    }

    public Setting clear(String group) {
        this.groupedMap.clear(group);
        return this;
    }

    public Set<String> keySet(String group) {
        return this.groupedMap.keySet(group);
    }

    public Collection<String> values(String group) {
        return this.groupedMap.values(group);
    }

    public Set<Map.Entry<String, String>> entrySet(String group) {
        return this.groupedMap.entrySet(group);
    }

    public Setting set(String key2, String value) {
        this.put(key2, value);
        return this;
    }

    public Setting setByGroup(String key2, String group, String value) {
        this.putByGroup(key2, group, value);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.groupedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.groupedMap.containsKey("", Convert.toStr(key2));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.groupedMap.containsValue("", Convert.toStr(value));
    }

    @Override
    public String get(Object key2) {
        return this.groupedMap.get("", Convert.toStr(key2));
    }

    @Override
    public String put(String key2, String value) {
        return this.groupedMap.put("", key2, value);
    }

    @Override
    public String remove(Object key2) {
        return this.groupedMap.remove("", Convert.toStr(key2));
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.groupedMap.putAll("", m);
    }

    @Override
    public void clear() {
        this.groupedMap.clear("");
    }

    @Override
    public Set<String> keySet() {
        return this.groupedMap.keySet("");
    }

    @Override
    public Collection<String> values() {
        return this.groupedMap.values("");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.groupedMap.entrySet("");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + this.groupedMap.hashCode();
        result = 31 * result + (this.isUseVariable ? 1231 : 1237);
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        if (this.charset == null ? other.charset != null : false == this.charset.equals(other.charset)) {
            return false;
        }
        if (!this.groupedMap.equals(other.groupedMap)) {
            return false;
        }
        if (this.isUseVariable != other.isUseVariable) {
            return false;
        }
        if (this.resource == null) {
            return other.resource == null;
        }
        return this.resource.equals(other.resource);
    }

    public String toString() {
        return this.groupedMap.toString();
    }
}

