/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SettingUtil {
    private static final Map<String, Setting> SETTING_MAP = new ConcurrentHashMap<String, Setting>();

    public static Setting get(String name2) {
        return SETTING_MAP.computeIfAbsent(name2, filePath -> {
            String extName = FileNameUtil.extName(filePath);
            if (StrUtil.isEmpty(extName)) {
                filePath = filePath + "." + "setting";
            }
            return new Setting((String)filePath, true);
        });
    }

    public static Setting getFirstFound(String ... names) {
        for (String name2 : names) {
            try {
                return SettingUtil.get(name2);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }
}

