/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting.dialect;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.BasicTypeGetter;
import cn.hutool.core.getter.OptBasicTypeGetter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.WatchUtil;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.StaticLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public final class Props
extends Properties
implements BasicTypeGetter<String>,
OptBasicTypeGetter<String> {
    private static final long serialVersionUID = 1935981579709590740L;
    public static final String EXT_NAME = "properties";
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient Charset charset = CharsetUtil.CHARSET_ISO_8859_1;

    public static Props create() {
        return new Props();
    }

    public static Props getProp(String resource2) {
        return new Props(resource2);
    }

    public static Props getProp(String resource2, String charsetName) {
        return new Props(resource2, charsetName);
    }

    public static Props getProp(String resource2, Charset charset) {
        return new Props(resource2, charset);
    }

    public Props() {
    }

    public Props(String path2) {
        this(path2, CharsetUtil.CHARSET_ISO_8859_1);
    }

    public Props(String path2, String charsetName) {
        this(path2, CharsetUtil.charset(charsetName));
    }

    public Props(String path2, Charset charset) {
        Assert.notBlank(path2, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResourceObj(path2));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, StandardCharsets.ISO_8859_1);
    }

    public Props(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public Props(File propertiesFile, Charset charset) {
        Assert.notNull(propertiesFile, "Null properties file!", new Object[0]);
        this.charset = charset;
        this.load(new FileResource(propertiesFile));
    }

    public Props(String path2, Class<?> clazz) {
        this(path2, clazz, "ISO-8859-1");
    }

    public Props(String path2, Class<?> clazz, String charsetName) {
        this(path2, clazz, CharsetUtil.charset(charsetName));
    }

    public Props(String path2, Class<?> clazz, Charset charset) {
        Assert.notBlank(path2, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(new ClassPathResource(path2, clazz));
    }

    public Props(URL propertiesUrl) {
        this(propertiesUrl, StandardCharsets.ISO_8859_1);
    }

    public Props(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, CharsetUtil.charset(charsetName));
    }

    public Props(URL propertiesUrl, Charset charset) {
        Assert.notNull(propertiesUrl, "Null properties URL !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(propertiesUrl);
    }

    public Props(Properties properties) {
        if (MapUtil.isNotEmpty(properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public void load(URL url) {
        this.load(new UrlResource(url));
    }

    public void load(Resource resource2) {
        Assert.notNull(resource2, "Props resource must be not null!", new Object[0]);
        this.resource = resource2;
        try (BufferedReader reader2 = resource2.getReader(this.charset);){
            super.load(reader2);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull(this.resource, "Properties resource must be not null!", new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Props.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoUtil.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    @Override
    public Object getObj(String key2, Object defaultValue) {
        return this.getStr(key2, null == defaultValue ? null : defaultValue.toString());
    }

    @Override
    public Object getObj(String key2) {
        return this.getObj(key2, (Object)null);
    }

    @Override
    public String getStr(String key2, String defaultValue) {
        return super.getProperty(key2, defaultValue);
    }

    @Override
    public String getStr(String key2) {
        return super.getProperty(key2);
    }

    @Override
    public Integer getInt(String key2, Integer defaultValue) {
        return Convert.toInt(this.getStr(key2), defaultValue);
    }

    @Override
    public Integer getInt(String key2) {
        return this.getInt(key2, (Integer)null);
    }

    @Override
    public Boolean getBool(String key2, Boolean defaultValue) {
        return Convert.toBool(this.getStr(key2), defaultValue);
    }

    @Override
    public Boolean getBool(String key2) {
        return this.getBool(key2, (Boolean)null);
    }

    @Override
    public Long getLong(String key2, Long defaultValue) {
        return Convert.toLong(this.getStr(key2), defaultValue);
    }

    @Override
    public Long getLong(String key2) {
        return this.getLong(key2, (Long)null);
    }

    @Override
    public Character getChar(String key2, Character defaultValue) {
        String value = this.getStr(key2);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public Character getChar(String key2) {
        return this.getChar(key2, (Character)null);
    }

    @Override
    public Float getFloat(String key2) {
        return this.getFloat(key2, (Float)null);
    }

    @Override
    public Float getFloat(String key2, Float defaultValue) {
        return Convert.toFloat(this.getStr(key2), defaultValue);
    }

    @Override
    public Double getDouble(String key2, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble(this.getStr(key2), defaultValue);
    }

    @Override
    public Double getDouble(String key2) throws NumberFormatException {
        return this.getDouble(key2, (Double)null);
    }

    @Override
    public Short getShort(String key2, Short defaultValue) {
        return Convert.toShort(this.getStr(key2), defaultValue);
    }

    @Override
    public Short getShort(String key2) {
        return this.getShort(key2, (Short)null);
    }

    @Override
    public Byte getByte(String key2, Byte defaultValue) {
        return Convert.toByte(this.getStr(key2), defaultValue);
    }

    @Override
    public Byte getByte(String key2) {
        return this.getByte(key2, (Byte)null);
    }

    @Override
    public BigDecimal getBigDecimal(String key2, BigDecimal defaultValue) {
        String valueStr = this.getStr(key2);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String key2) {
        return this.getBigDecimal(key2, (BigDecimal)null);
    }

    @Override
    public BigInteger getBigInteger(String key2, BigInteger defaultValue) {
        String valueStr = this.getStr(key2);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    @Override
    public BigInteger getBigInteger(String key2) {
        return this.getBigInteger(key2, (BigInteger)null);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key2, E defaultValue) {
        return Convert.toEnum(clazz, this.getStr(key2), defaultValue);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key2) {
        return this.getEnum(clazz, key2, (E)null);
    }

    @Override
    public Date getDate(String key2, Date defaultValue) {
        return Convert.toDate(this.getStr(key2), defaultValue);
    }

    @Override
    public Date getDate(String key2) {
        return this.getDate(key2, (Date)null);
    }

    public String getAndRemoveStr(String ... keys2) {
        String key2;
        Object value = null;
        String[] stringArray = keys2;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key2 = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        T bean2 = ReflectUtil.newInstanceIfPossible(beanClass);
        return this.fillBean(bean2, prefix);
    }

    public <T> T fillBean(T bean2, String prefix) {
        prefix = StrUtil.nullToEmpty(StrUtil.addSuffixIfNot(prefix, "."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key2 = (String)entry.getKey();
            if (!StrUtil.startWith((CharSequence)key2, prefix)) continue;
            try {
                BeanUtil.setProperty(bean2, StrUtil.subSuf(key2, prefix.length()), entry.getValue());
            }
            catch (Exception e2) {
                StaticLog.debug("Ignore property: [{}]", key2);
            }
        }
        return bean2;
    }

    public void setProperty(String key2, Object value) {
        super.setProperty(key2, value.toString());
    }

    public void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer2 = null;
        try {
            writer2 = FileUtil.getWriter(absolutePath, this.charset, false);
            super.store(writer2, null);
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2, "Store properties to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoUtil.close(writer2);
                throw throwable;
            }
        }
        IoUtil.close(writer2);
    }

    public void store(String path2, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path2, clazz));
    }
}

